<?php
/**
 * Destum back compat functionality
 *
 * Prevents Destum from running on WordPress versions prior to 4.7,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.7.
 *
 * @since Destum 1.0.0
 */

/**
 * Prevent switching to Destum on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since Destum 1.0.0
 */
function destum_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'destum_upgrade_notice' );
}
add_action( 'after_switch_theme', 'destum_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * Destum on WordPress versions prior to 4.7.
 *
 * @since Destum 1.0.0
 * @global string $wp_version WordPress version.
 */
function destum_upgrade_notice() {
	$message = sprintf( esc_html__( 'Destum requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'destum-temp' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.7.
 *
 * @since Destum 1.0.0
 *
 * @global string $wp_version WordPress version.
 */
function destum_customize() {
	wp_die( sprintf( esc_html__( 'Destum requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'destum-temp' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'destum_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.7.
 *
 * @since Destum 1.0.0
 * @global string $wp_version WordPress version.
 */
function destum_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( esc_html__( 'Destum requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'destum-temp' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'destum_preview' );
