<?php
/**
 * @author    ThemePunch <info@themepunch.com>
 * @link      http://www.themepunch.com/
 * @copyright 2015 ThemePunch
 */

if( !defined( 'ABSPATH') ) exit();

class DestumSliderAdmin extends DestumSliderBaseAdmin{

	const VIEW_SLIDER = "slider";
	const VIEW_SLIDER_TEMPLATE = "slider_template"; //obsolete
	const VIEW_SLIDERS = "sliders";
	const VIEW_SLIDES = "slides";
	const VIEW_SLIDE = "slide";
	
	/**
	 * the constructor
	 */
	public function __construct(){

		parent::__construct($this);

		//set table names
		DestumSliderGlobals::$table_sliders = self::$table_prefix.DestumSliderGlobals::TABLE_SLIDERS_NAME;
		DestumSliderGlobals::$table_slides = self::$table_prefix.DestumSliderGlobals::TABLE_SLIDES_NAME;
		DestumSliderGlobals::$table_static_slides = self::$table_prefix.DestumSliderGlobals::TABLE_STATIC_SLIDES_NAME;
		DestumSliderGlobals::$table_settings = self::$table_prefix.DestumSliderGlobals::TABLE_SETTINGS_NAME;
		DestumSliderGlobals::$table_css = self::$table_prefix.DestumSliderGlobals::TABLE_CSS_NAME;
		DestumSliderGlobals::$table_layer_anims = self::$table_prefix.DestumSliderGlobals::TABLE_LAYER_ANIMS_NAME;
		DestumSliderGlobals::$table_navigation = self::$table_prefix.DestumSliderGlobals::TABLE_NAVIGATION_NAME;

		DestumSliderGlobals::$filepath_backup = RS_PLUGIN_PATH.'backup/';
		DestumSliderGlobals::$filepath_captions = RS_PLUGIN_PATH.'public/assets/css/captions.css';
		DestumSliderGlobals::$urlCaptionsCSS = RS_PLUGIN_URL.'public/assets/css/captions.php';
		DestumSliderGlobals::$filepath_dynamic_captions = RS_PLUGIN_PATH.'public/assets/css/dynamic-captions.css';
		DestumSliderGlobals::$filepath_captions_original = RS_PLUGIN_PATH.'public/assets/css/captions-original.css';
		
		$wp_upload_dir = wp_upload_dir();
		$wp_upload_dir = $wp_upload_dir['basedir'].'/';
		DestumSliderGlobals::$uploadsUrlExportZip = $wp_upload_dir.'export.zip';

		$this->init();
	}


	/**
	 * init all actions
	 */
	private function init(){
		global $DestumSliderAsTheme;
		global $pagenow;
		
		$template = new DestumSliderTemplate();
		$operations = new DestumSliderOperations();
		$obj_library = new DestumSliderObjectLibrary();
		$general_settings = $operations->getGeneralSettingsValues();
		
		$role = DestumSliderBase::getVar($general_settings, 'role', 'admin');
		$force_activation_box = DestumSliderBase::getVar($general_settings, 'force_activation_box', 'off');
		
		if($force_activation_box == 'on'){ //force the notifications and more
			$DestumSliderAsTheme = false;
		}
		
		self::setMenuRole($role);

		self::addMenuPage('Destum Slider', "adminPages");
		
		self::addSubMenuPage(__('Navigation Editor', 'DestumSlider'), 'display_plugin_submenu_page_navigation', 'DestumSlider_navigation');
		self::addSubMenuPage(__('Global Settings', 'DestumSlider'), 'display_plugin_submenu_page_global_settings', 'DestumSlider_global_settings');
		

		$this->addSliderMetaBox();

		//ajax response to save slider options.
		self::addActionAjax("ajax_action", "onAjaxAction");
		
		$upgrade = new DestumSliderUpdate( GlobalsDestumSlider::SLIDER_REVISION );
		
		$temp_active = get_option('DestumSlider-temp-active', 'false');
		
		if($temp_active == 'true'){ //check once an hour
			$temp_force = (isset($_GET['checktempactivate'])) ? true : false;
			$upgrade->add_temp_active_check($temp_force);
		}
		
		//add common scripts there
		$validated = get_option('DestumSlider-valid', 'false');
		$notice = get_option('DestumSlider-valid-notice', 'true');
		$latestv = DestumSliderGlobals::SLIDER_REVISION;
		$stablev = get_option('DestumSlider-stable-version', '0');
		
		if(!$DestumSliderAsTheme || version_compare($latestv, $stablev, '<')){
			if($validated === 'false' && $notice === 'true'){
				add_action('admin_notices', array($this, 'addActivateNotification'));
			}

			if(isset($_GET['checkforupdates']) && $_GET['checkforupdates'] == 'true')
				$upgrade->_retrieve_version_info(true);
			
			if($validated === 'true' || version_compare($latestv, $stablev, '<')) {
				$upgrade->add_update_checks();
			}
		}
		
		
		if(isset($_REQUEST['update_shop'])){
			$template->_get_template_list(true);
		}else{
			$template->_get_template_list();
		}
		
		if(isset($_REQUEST['update_object_library'])){
			$obj_library->_get_list(true);
		}else{
			$obj_library->_get_list();
		}
		
		$upgrade->_retrieve_version_info();
		add_action('admin_notices', array($this, 'add_notices'));
		
		add_action('admin_enqueue_scripts', array('DestumSliderAdmin', 'enqueue_styles'));
		
		add_action('admin_enqueue_scripts', array('DestumSliderAdmin', 'enqueue_all_admin_scripts'));
		
		add_action('wp_ajax_DestumSlider_ajax_call_front', array('DestumSliderAdmin', 'onFrontAjaxAction'));
		add_action('wp_ajax_nopriv_DestumSlider_ajax_call_front', array('DestumSliderAdmin', 'onFrontAjaxAction')); //for not logged in users
		
		add_action( 'admin_head', array('DestumSliderAdmin', 'include_custom_css' ));
		
		if(isset($pagenow) && $pagenow == 'plugins.php'){
			add_action('admin_notices', array('DestumSliderAdmin', 'add_plugins_page_notices'));
		}
		
		// Add-on Admin
		$addon_admin = new Rev_addon_Admin( 'rev_addon', DestumSliderGlobals::SLIDER_REVISION );
		add_action( 'admin_enqueue_scripts', array( $addon_admin, 'enqueue_styles') );
		add_action( 'admin_enqueue_scripts', array( $addon_admin, 'enqueue_scripts') );
		add_action( 'admin_menu', array( $addon_admin, 'add_plugin_admin_menu'), 11 );
		// Add-on Admin Button Ajax Actions
		add_action( 'wp_ajax_activate_plugin', array( $addon_admin, 'activate_plugin') );
		//add_action( 'wp_ajax_nopriv_activate_plugin', array( $addon_admin, 'activate_plugin') );
		add_action( 'wp_ajax_deactivate_plugin', array( $addon_admin, 'deactivate_plugin'));
		//add_action( 'wp_ajax_nopriv_deactivate_plugin', array( $addon_admin, 'deactivate_plugin') );
		add_action( 'wp_ajax_install_plugin', array( $addon_admin, 'install_plugin'));
		//add_action( 'wp_ajax_nopriv_install_plugin', array( $addon_admin, 'install_plugin') );
		
		//add_filter('plugin_action_links', array('DestumSliderAdmin', 'plugin_action_links' ), 10, 2);
	}
	
	
	public static function add_plugins_page_notices(){
		$plugins = get_plugins();
        
        foreach($plugins as $plugin_id => $plugin){
            
            $slug = dirname($plugin_id);
            if(empty($slug)) continue;
			if($slug !== 'DestumSlider') continue;
            
			//check version, latest updates and if registered or not
			$validated = get_option('DestumSlider-valid', 'false');
			$latestv = get_option('DestumSlider-latest-version', DestumSliderGlobals::SLIDER_REVISION);
			
			if($validated == 'false'){ //activate for updates and support
				add_action( "after_plugin_row_" . $plugin_id, array('DestumSliderAdmin', 'show_purchase_notice'), 10, 3);
			}
			
			if(version_compare($latestv, $plugin['Version'], '>')){
				add_action( "after_plugin_row_" . $plugin_id, array('DestumSliderAdmin', 'show_update_notice'), 10, 3);
			}
		}   
	}
	
	
	public static function show_purchase_notice(){
		$wp_list_table = _get_list_table('WP_Plugins_List_Table');
        ?>
        <tr class="plugin-update-tr"><td colspan="<?php echo $wp_list_table->get_column_count(); ?>" class="plugin-update colspanchange">
            <div class="update-message installer-q-icon">
            <?php _e('Activate Destum Slider for <a href="http://revolution.themepunch.com/direct-customer-benefits/" target="_blank">Premium Benefits (e.g. Live Updates)</a>.', 'DestumSlider'); ?>
            </div>
        </tr>
        <?php 
	}
	
	
	public static function show_update_notice(){
		$wp_list_table = _get_list_table('WP_Plugins_List_Table');
        ?>
        <tr class="plugin-update-tr"><td colspan="<?php echo $wp_list_table->get_column_count(); ?>" class="plugin-update colspanchange">
            <div class="update-message">
            <?php _e('A new version of Destum Slider is available.', 'DestumSlider'); ?>
            </div>
        </tr>
        <?php 
	}
	
	
	public static function plugin_action_links($links, $file){
		if ($file == plugin_basename(RS_PLUGIN_FILE_PATH)){
			$rs_enabled = get_option('DestumSlider-valid', 'false');
			
			if($rs_enabled == 'true'){
				krsort($links);
				end($links);
				$key = key($links);
				$links[$key] .= '';
			}
		}
		
		return $links;
	}
	
	
	public static function enqueue_styles(){
		wp_enqueue_style('rs-open-sans', '//fonts.googleapis.com/css?family=Open+Sans:400,300,700,600,800');
		wp_enqueue_style('DestumSlider-global-styles', RS_PLUGIN_URL . 'admin/assets/css/global.css', array(), GlobalsDestumSlider::SLIDER_REVISION );
	}

	
	public static function include_custom_css(){
		
		$type = (isset($_GET['view'])) ? $_GET['view'] : '';
		$page = (isset($_GET['page'])) ? $_GET['page'] : '';
		
		if($page !== 'slider' && $page !== 'DestumSlider_navigation') return false; //showbiz fix
		
		$sliderID = '';
		
		switch($type){
			case 'slider':
				
				$sliderID = (isset($_GET['id'])) ? $_GET['id'] : '';
			break;
			case 'slide':
				$slideID = (isset($_GET['id'])) ? $_GET['id'] : '';
				if($slideID == 'new') break;
				
				$slide = new RevSlide();
				$slide->initByID($slideID);
				$sliderID = $slide->getSliderID();
			break;
			default:
				if(isset($_GET['slider'])){
					$sliderID = $_GET['slider'];
				}
			break;
		}

		$arrFieldsParams = array();

		if(!empty($sliderID)){
			$slider = new DestumSlider();
			$slider->initByID($sliderID);
			$settingsFields = $slider->getSettingsFields();
			$arrFieldsMain = $settingsFields['main'];
			$arrFieldsParams = $settingsFields['params'];			
			$custom_css = @stripslashes($arrFieldsParams['custom_css']);
			$custom_css = DestumSliderCssParser::compress_css($custom_css);
			echo '<style>'.$custom_css.'</style>';
		}
	}
	
	
	public static function enqueue_all_admin_scripts() {
		wp_localize_script('unite_admin', 'rev_lang', self::get_javascript_multilanguage()); //Load multilanguage for JavaScript
		
		wp_enqueue_style(array('wp-color-picker'));
		wp_enqueue_script(array('wp-color-picker'));

		//enqueue TP-COLOR 
		wp_enqueue_style('tp-color-picker-css', plugins_url('../public/assets/css/tp-color-picker.css', __FILE__ ), array(), DestumSliderGlobals::SLIDER_REVISION);
		wp_enqueue_script('tp-color-picker-js', plugins_url('../public/assets/js/tp-color-picker.min.js', __FILE__ ), array('jquery'), DestumSliderGlobals::SLIDER_REVISION);
		
		
		//enqueue in all pages / posts in backend
		$screen = get_current_screen();
		
		$post_types = get_post_types( '', 'names' ); 
		foreach($post_types as $post_type) {
			if($post_type == $screen->id){
				wp_enqueue_script('DestumSlider-tinymce-shortcode-script', RS_PLUGIN_URL . 'admin/assets/js/tinymce-shortcode-script.js', array('jquery'), DestumSliderGlobals::SLIDER_REVISION );
			}
		}
	}
	

	/**
	 * Include wanted submenu page
	 */
	public function display_plugin_submenu_page_navigation() {
		self::display_plugin_submenu('navigation-editor');
	}
	

	/**
	 * Include wanted submenu page
	 */
	public function display_plugin_submenu_page_global_settings() {
		self::display_plugin_submenu('global-settings');
	}
	

	/**
	 * Include wanted submenu page
	 */
	public function display_plugin_submenu_page_google_fonts() {
		self::display_plugin_submenu('themepunch-google-fonts');
	}

	
	public static function display_plugin_submenu($subMenu){

		parent::adminPages();

		self::setMasterView('master-view');
		self::requireView($subMenu);
	}
	
	
	/**
	 * Create Multilanguage for JavaScript
	 */
	protected static function get_javascript_multilanguage(){
		$lang = array(
			'wrong_alias' => __('-- wrong alias -- ', 'DestumSlider'),
			'nav_bullet_arrows_to_none' => __('Navigation Bullets and Arrows are now set to none.', 'DestumSlider'),
			'create_template' => __('Create Template', 'DestumSlider'),
			'really_want_to_delete' => __('Do you really want to delete', 'DestumSlider'),
			'sure_to_replace_urls' => __('Are you sure to replace the urls?', 'DestumSlider'),
			'set_settings_on_all_slider' => __('Set selected settings on all Slides of this Slider? (This will be saved immediately)', 'DestumSlider'),
			'select_slide_img' => __('Select Slide Image', 'DestumSlider'),
			'select_layer_img' => __('Select Layer Image', 'DestumSlider'),
			'select_slide_video' => __('Select Slide Video', 'DestumSlider'),
			'show_slide_opt' => __('Show Slide Options', 'DestumSlider'),
			'hide_slide_opt' => __('Hide Slide Options', 'DestumSlider'),
			'close' => __('Close', 'DestumSlider'),
			'really_update_global_styles' => __('Really update global styles?', 'DestumSlider'),
			'really_clear_global_styles' => __('This will remove all Global Styles, continue?', 'DestumSlider'),
			'global_styles_editor' => __('Global Styles Editor', 'DestumSlider'),
			'select_image' => __('Select Image', 'DestumSlider'),
			'video_not_found' => __('No Thumbnail Image Set on Video / Video Not Found / No Valid Video ID', 'DestumSlider'),
			'handle_at_least_three_chars' => __('Handle has to be at least three character long', 'DestumSlider'),
			'really_change_font_sett' => __('Really change font settings?', 'DestumSlider'),
			'really_delete_font' => __('Really delete font?', 'DestumSlider'),
			'class_exist_overwrite' => __('Class already exists, overwrite?', 'DestumSlider'),
			'class_must_be_valid' => __('Class must be a valid CSS class name', 'DestumSlider'),
			'really_overwrite_class' => __('Really overwrite Class?', 'DestumSlider'),
			'relly_delete_class' => __('Really delete Class', 'DestumSlider'),
			'class_this_cant_be_undone' => __('? This can\'t be undone!', 'DestumSlider'),
			'this_class_does_not_exist' => __('This class does not exist.', 'DestumSlider'),
			'making_changes_will_probably_overwrite_advanced' => __('Making changes to these settings will probably overwrite advanced settings. Continue?', 'DestumSlider'),
			'select_static_layer_image' => __('Select Static Layer Image', 'DestumSlider'),
			'select_layer_image' => __('Select Layer Image', 'DestumSlider'),
			'really_want_to_delete_all_layer' => __('Do you really want to delete all the layers?', 'DestumSlider'),
			'layer_animation_editor' => __('Layer Animation Editor', 'DestumSlider'),
			'animation_exists_overwrite' => __('Animation already exists, overwrite?', 'DestumSlider'),
			'really_overwrite_animation' => __('Really overwrite animation?', 'DestumSlider'),
			'default_animations_cant_delete' => __('Default animations can\'t be deleted', 'DestumSlider'),
			'must_be_greater_than_start_time' => __('Must be greater than start time', 'DestumSlider'),
			'sel_layer_not_set' => __('Selected layer not set', 'DestumSlider'),
			'edit_layer_start' => __('Edit Layer Start', 'DestumSlider'),
			'edit_layer_end' => __('Edit Layer End', 'DestumSlider'),
			'default_animations_cant_rename' => __('Default Animations can\'t be renamed', 'DestumSlider'),
			'anim_name_already_exists' => __('Animationname already existing', 'DestumSlider'),
			'css_name_already_exists' => __('CSS classname already existing', 'DestumSlider'),
			'css_orig_name_does_not_exists' => __('Original CSS classname not found', 'DestumSlider'),
			'enter_correct_class_name' => __('Enter a correct class name', 'DestumSlider'),
			'class_not_found' => __('Class not found in database', 'DestumSlider'),
			'css_name_does_not_exists' => __('CSS classname not found', 'DestumSlider'),
			'delete_this_caption' => __('Delete this caption? This may affect other Slider', 'DestumSlider'),
			'this_will_change_the_class' => __('This will update the Class with the current set Style settings, this may affect other Sliders. Proceed?', 'DestumSlider'),
			'unsaved_changes_will_not_be_added' => __('Template will have the state of the last save, proceed?', 'DestumSlider'),
			'please_enter_a_slide_title' => __('Please enter a Slide title', 'DestumSlider'),
			'please_wait_a_moment' => __('Please Wait a Moment', 'DestumSlider'),
			'copy_move' => __('Copy / Move', 'DestumSlider'),
			'preset_loaded' => __('Preset Loaded', 'DestumSlider'),
			'add_bulk_slides' => __('Add Bulk Slides', 'DestumSlider'),
			'select_image' => __('Select Image', 'DestumSlider'),
			'arrows' => __('Arrows', 'DestumSlider'),
			'bullets' => __('Bullets', 'DestumSlider'),
			'thumbnails' => __('Thumbnails', 'DestumSlider'),
			'tabs' => __('Tabs', 'DestumSlider'),
			'delete_navigation' => __('Delete this Navigation?', 'DestumSlider'),
			'could_not_update_nav_name' => __('Navigation name could not be updated', 'DestumSlider'),
			'name_too_short_sanitize_3' => __('Name too short, at least 3 letters between a-zA-z needed', 'DestumSlider'),
			'nav_name_already_exists' => __('Navigation name already exists, please choose a different name', 'DestumSlider'),
			'remove_nav_element' => __('Remove current element from Navigation?', 'DestumSlider'),
			'create_this_nav_element' => __('This navigation element does not exist, create one?', 'DestumSlider'),
			'overwrite_animation' => __('Overwrite current animation?', 'DestumSlider'),
			'cant_modify_default_anims' => __('Default animations can\'t be changed', 'DestumSlider'),
			'anim_with_handle_exists' => __('Animation already existing with given handle, please choose a different name.', 'DestumSlider'),
			'really_delete_anim' => __('Really delete animation:', 'DestumSlider'),
			'this_will_reset_navigation' => __('This will reset the navigation, continue?', 'DestumSlider'),
			'preset_name_already_exists' => __('Preset name already exists, please choose a different name', 'DestumSlider'),
			'delete_preset' => __('Really delete this preset?', 'DestumSlider'),
			'update_preset' => __('This will update the preset with the current settings. Proceed?', 'DestumSlider'),
			'maybe_wrong_yt_id' => __('No Thumbnail Image Set on Video / Video Not Found / No Valid Video ID', 'DestumSlider'),
			'preset_not_found' => __('Preset not found', 'DestumSlider'),
			'cover_image_needs_to_be_set' => __('Cover Image need to be set for videos', 'DestumSlider'),
			'remove_this_action' => __('Really remove this action?', 'DestumSlider'),
			'layer_action_by' => __('Layer is triggered by ', 'DestumSlider'),
			'due_to_action' => __(' due to action: ', 'DestumSlider'),
			'layer' => __('layer:', 'DestumSlider'),
			'start_layer_in' => __('Start Layer "in" animation', 'DestumSlider'),
			'start_layer_out' => __('Start Layer "out" animation', 'DestumSlider'),
			'start_video' => __('Start Media', 'DestumSlider'),
			'stop_video' => __('Stop Media', 'DestumSlider'),
			'mute_video' => __('Mute Media', 'DestumSlider'),
			'unmute_video' => __('Unmute Media', 'DestumSlider'),
			'toggle_layer_anim' => __('Toggle Layer Animation', 'DestumSlider'),
			'toggle_video' => __('Toggle Media', 'DestumSlider'),
			'toggle_mute_video' => __('Toggle Mute Media', 'DestumSlider'),
			'toggle_global_mute_video' => __('Toggle Mute All Media', 'DestumSlider'),
			'last_slide' => __('Last Slide', 'DestumSlider'),
			'simulate_click' => __('Simulate Click', 'DestumSlider'),
			'togglefullscreen' => __('Toggle FullScreen', 'DestumSlider'),
			'gofullscreen' => __('Go FullScreen', 'DestumSlider'),
			'exitfullscreen' => __('Exit FullScreen', 'DestumSlider'),
			'toggle_class' => __('Toogle Class', 'DestumSlider'),
			'copy_styles_to_hover_from_idle' => __('Copy hover styles to idle?', 'DestumSlider'),
			'copy_styles_to_idle_from_hover' => __('Copy idle styles to hover?', 'DestumSlider'),
			'select_at_least_one_device_type' => __('Please select at least one device type', 'DestumSlider'),
			'please_select_first_an_existing_style' => __('Please select an existing Style Template', 'DestumSlider'),
			'cant_remove_last_transition' => __('Can not remove last transition!', 'DestumSlider'),
			'name_is_default_animations_cant_be_changed' => __('Given animation name is a default animation. These can not be changed.', 'DestumSlider'),
			'override_animation' => __('Animation exists, override existing animation?', 'DestumSlider'),
			'this_feature_only_if_activated' => __('This feature is only available if you activate Destum Slider for this installation', 'DestumSlider'),
			'unsaved_data_will_be_lost_proceed' => __('Unsaved data will be lost, proceed?', 'DestumSlider'),
			'delete_user_slide' => __('This will delete this Slide Template, proceed?', 'DestumSlider'),
			'is_loading' => __('is Loading...', 'DestumSlider'),
			'google_fonts_loaded' => __('Google Fonts Loaded', 'DestumSlider'),
			'delete_layer' => __('Delete Layer?', 'DestumSlider'),
			'this_template_requires_version' => __('This template requires at least version', 'DestumSlider'),
			'of_slider_revolution' => __('of Destum Slider to work.', 'DestumSlider'),
			'slider_revolution_shortcode_creator' => __('Destum Slider Shortcode Creator', 'DestumSlider'),
			'slider_informations_are_missing' => __('Slider informations are missing!', 'DestumSlider'),
			'shortcode_generator' => __('Shortcode Generator', 'DestumSlider'),
			'please_add_at_least_one_layer' => __('Please add at least one Layer.', 'DestumSlider'),
			'choose_image' => __('Choose Image', 'DestumSlider'),
			'shortcode_parsing_successfull' => __('Shortcode parsing successfull. Items can be found in step 3', 'DestumSlider'),
			'shortcode_could_not_be_correctly_parsed' => __('Shortcode could not be parsed.', 'DestumSlider'),
			'background_video' => __('Background Video', 'DestumSlider'),
			'active_video' => __('Video in Active Slide', 'DestumSlider'),
			'empty_data_retrieved_for_slider' => __('Data could not be fetched for selected Slider', 'DestumSlider'),
			'import_selected_layer' => __('Import Selected Layer?', 'DestumSlider'),
			'import_all_layer_from_actions' => __('Layer Imported! The Layer has actions which include other Layers. Import all connected layers?', 'DestumSlider'),
            'not_available_in_demo' => __('Not available in Demo Mode', 'DestumSlider'),
            'leave_not_saved' => __('By leaving now, all changes since the last saving will be lost. Really leave now?', 'DestumSlider'),
            'static_layers' => __('--- Static Layers ---', 'DestumSlider'),
            'objects_only_available_if_activated' => __('Only available if plugin is activated', 'DestumSlider'),
            'download_install_takes_longer' => __('Download/Install takes longer than usual, please wait', 'DestumSlider'),
            'download_failed_check_server' => __('<div class="import_failure">Download/Install seems to have failed.</div><br>Please check your server <span class="import_failure">download speed</span> and  if the server can programatically connect to <span class="import_failure">http://templates.themepunch.com</span><br><br>', 'DestumSlider'),
            'aborting_import' => __('<b>Aborting Import...</b>', 'DestumSlider'),
            'create_draft' => __('Creating Draft Page...', 'DestumSlider'),
            'draft_created' => __('Draft Page created. Popup will open', 'DestumSlider'),
            'draft_not_created' => __('Draft Page could not be created.', 'DestumSlider'),
            'slider_import_success_reload' => __('Slider import successful', 'DestumSlider'),
            'save_changes' => __('Save Changes?', 'DestumSlider')
		);

		return $lang;
	}

	
	public function addActivateNotification(){
		$nonce = wp_create_nonce("DestumSlider_actions");
		?>
		<div class="updated below-h2 rs-update-notice-wrap" id="message"><a href="javascript:void(0);" style="float: right;padding-top: 9px;" id="rs-dismiss-notice"><?php _e('(never show this message again)&nbsp;&nbsp;<b>X</b>','DestumSlider'); ?></a><p><?php _e('Hi! Would you like to activate your version of Revolution Slider to receive live updates & get premium support? This is optional and not needed if the slider came bundled with a theme. ','DestumSlider'); ?></p></div>
		<script type="text/javascript">
			jQuery('#rs-dismiss-notice').click(function(){
				var objData = {
							action:"DestumSlider_ajax_action",
							client_action: 'dismiss_notice',
							nonce:'<?php echo $nonce; ?>',
							data:''
							};

				jQuery.ajax({
					type:"post",
					url:ajaxurl,
					dataType: 'json',
					data:objData
				});

				jQuery('.rs-update-notice-wrap').hide();
			});
		</script>
		<?php
	}
	
	
	/**
	 * add notices from ThemePunch
	 * @since: 4.6.8
	 */
	public function add_notices(){
		$operations = new DestumSliderOperations();
		$general_settings = $operations->getGeneralSettingsValues();
		
		//check permissions here
		if(!current_user_can('administrator')) return true;

		$enable_newschannel = DestumSliderBase::getVar($general_settings, 'enable_newschannel', 'on');
		
		$enable_newschannel = apply_filters('DestumSlider_set_notifications', $enable_newschannel);
		
		if($enable_newschannel == 'on'){
			
			$nonce = wp_create_nonce("DestumSlider_actions");
			
			$notices = get_option('DestumSlider-notices', false);
			
			$vn = get_option('DestumSlider-deact-notice', false);
			
			if($vn == true){
				$notices[99999] = new stdClass();
				$notices[99999]->code = 'DISCARD';
				$notices[99999]->version = '99.99';
				$notices[99999]->is_global = false;
				$notices[99999]->color = 'error';
				$notices[99999]->text = '<p>'.__('Hi, your Purchase Code for Destum Slider has been deregistered manually through <a href="https://www.themepunch.com/purchase-code-deactivation" target="_blank">https://www.themepunch.com/purchase-code-deactivation</a> and is no longer active for this installation.', 'DestumSlider').'</p>';
				$notices[99999]->disable = false;
				$notices[99999]->additional = array();
			}
			
			$tmp = get_option('DestumSlider-temp-active-notice', 'false');
			
			if($tmp == 'true'){
				$notices[99998] = new stdClass();
				$notices[99998]->code = 'DISCARDTEMPACT';
				$notices[99998]->version = '99.99';
				$notices[99998]->is_global = false;
				$notices[99998]->color = 'error';
				$notices[99998]->text = '<p>'.__('Hi, your Purchase Code for Destum Slider has been deregistered as it was not a valid Destum Slider Purchase Code', 'DestumSlider').'</p>';
				$notices[99998]->disable = false;
				$notices[99998]->additional = array();
			}
			
			if(!empty($notices) && is_array($notices)){
				global $DestumSlider_screens;
				
				$notices_discarded = get_option('DestumSlider-notices-dc', array());
				
				$screen = get_current_screen();
				foreach($notices as $notice){
					if($notice->is_global !== true && !in_array($screen->id, $DestumSlider_screens)) continue; //check if global or just on plugin related pages
						
					if(!in_array($notice->code, $notices_discarded) && version_compare($notice->version, GlobalsDestumSlider::SLIDER_REVISION, '>=')){
						$text = '<div style="text-align:right;vertical-align:middle;display:table-cell; min-width:225px;border-left:1px solid #ddd; padding-left:15px;"><a href="javascript:void(0);"  class="rs-notices-button rs-notice-'. esc_attr($notice->code) .'">'. __('Close & don\'t show again<b>X</b>','DestumSlider') .'</a></div>';
						if($notice->disable == true) $text = '';
						?>
							<style>
						.rs-notices-button			{	color:#999; text-decoration: none !important; font-size:14px;font-weight: 400;}
						.rs-notices-button:hover 	{	color:#3498DB !important;}

						.rs-notices-button b 		{	font-weight:800; vertical-align:bottom;line-height:15px;font-size:10px;margin-left:10px;margin-right:10px;border:2px solid #999; display:inline-block; width:15px;height:15px; text-align: center; border-radius: 50%; -webkit-border-radius: 50%; -moz-border-radius: 50%;}
						.rs-notices-button:hover b  { 	border-color:#3498DB;}
						</style>
						<div class="<?php echo $notice->color; ?> below-h2 rs-update-notice-wrap" id="message" style="clear:both;display: block;position:relative;margin:35px 20px 25px 0px"><div style="display:table;width:100%;"><div style="vertical-align:middle;display:table-cell;min-width:100%;padding-right:15px;"><?php echo $notice->text; ?></div><?php echo $text; ?></div></div>

						<?php
					}
				}
				?>
				<script type="text/javascript">
					jQuery('.rs-notices-button').click(function(){
						
						var notice_id = jQuery(this).attr('class').replace('rs-notices-button', '').replace('rs-notice-', '');
						
						var objData = {
										action:"DestumSlider_ajax_action",
										client_action: 'dismiss_dynamic_notice',
										nonce:'<?php echo $nonce; ?>',
										data:{'id':notice_id}
										};

						jQuery.ajax({
							type:"post",
							url:ajaxurl,
							dataType: 'json',
							data:objData
						});

						jQuery(this).closest('.rs-update-notice-wrap').slideUp(200);
					});
				</script>
				<?php
			}
		}
	}
	
	
	/**
	 *
	 * add wildcards metabox variables to posts
	 */
	private function addSliderMetaBox($postTypes = null){ //null = all, post = only posts
		try{
			self::addMetaBox("Revolution Slider Options",'',array("DestumSliderAdmin","customPostFieldsOutput"),$postTypes);
		}catch(Exception $e){}
	}


	/**
	 *  custom output function
	 */
	public static function customPostFieldsOutput(){
		
		$meta = get_post_meta(get_the_ID(), 'slide_template', true);
		if($meta == '') $meta = 'default';
		
		$slider = new DestumSlider();
		$arrOutput = array();
		$arrOutput["default"] = "default";

		$arrSlides = $slider->getArrSlidersWithSlidesShort(DestumSlider::SLIDER_TYPE_TEMPLATE);
		$arrOutput = $arrOutput + $arrSlides;	//union arrays
		
		?>
		<ul class="DestumSlider_settings">
			<li id="slide_template_row">
				<div title="" class="setting_text" id="slide_template_text"><?php _e('Choose Slide Template', 'DestumSlider'); ?></div>
				<div class="setting_input">
					<select name="slide_template" id="slide_template">
						<?php
						foreach($arrOutput as $handle => $name){
							echo '<option '.selected($handle, $meta).' value="'.$handle.'">'.$name.'</option>';
						}
						?>
					</select>
				</div>
				<div class="clear"></div>
			</li>
		</ul>
		<?php
	}


	/**
	 * a must function. please don't remove it.
	 * process activate event - install the db (with delta).
	 */
	public static function onActivate(){
		DestumSliderFront::createDBTables();
	}


	/**
	 * a must function. adds scripts on the page
	 * add all page scripts and styles here.
	 * pelase don't remove this function
	 * common scripts even if the plugin not load, use this function only if no choise.
	 */
	public static function onAddScripts(){
		global $wp_version;
		
		$style_pre = '';
		$style_post = '';
		if($wp_version < 3.7){
			$style_pre = '<style type="text/css">';
			$style_post = '</style>';
		}
		
		wp_enqueue_style('edit_layers', RS_PLUGIN_URL .'admin/assets/css/edit_layers.css', array(), DestumSliderGlobals::SLIDER_REVISION);
		
		wp_enqueue_script('unite_layers_timeline', RS_PLUGIN_URL .'admin/assets/js/edit_layers_timeline.js', array(), DestumSliderGlobals::SLIDER_REVISION );
		wp_enqueue_script('unite_context_menu', RS_PLUGIN_URL .'admin/assets/js/context_menu.js', array(), DestumSliderGlobals::SLIDER_REVISION );
		wp_enqueue_script('unite_layers', RS_PLUGIN_URL .'admin/assets/js/edit_layers.js', array('jquery-ui-mouse'), DestumSliderGlobals::SLIDER_REVISION );
		wp_enqueue_script('unite_css_editor', RS_PLUGIN_URL .'admin/assets/js/css_editor.js', array(), DestumSliderGlobals::SLIDER_REVISION );
		wp_enqueue_script('rev_admin', RS_PLUGIN_URL .'admin/assets/js/rev_admin.js', array(), DestumSliderGlobals::SLIDER_REVISION );
		
		wp_enqueue_script('tp-tools', RS_PLUGIN_URL .'public/assets/js/jquery.themepunch.tools.min.js', array(), DestumSliderGlobals::SLIDER_REVISION );

		//include all media upload scripts
		self::addMediaUploadIncludes();

		//add rs css:
		wp_enqueue_style('rs-plugin-settings', RS_PLUGIN_URL .'public/assets/css/settings.css', array(), DestumSliderGlobals::SLIDER_REVISION);
		
		//add icon sets
		wp_enqueue_style('rs-icon-set-fa-icon-', RS_PLUGIN_URL .'public/assets/fonts/font-awesome/css/font-awesome.css', array(), DestumSliderGlobals::SLIDER_REVISION);
		wp_enqueue_style('rs-icon-set-pe-7s-', RS_PLUGIN_URL .'public/assets/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css', array(), DestumSliderGlobals::SLIDER_REVISION);
		
		add_filter('DestumSlider_mod_icon_sets', array('DestumSliderBase', 'set_icon_sets'));
		
		$db = new DestumSliderDB();

		$styles = $db->fetch(DestumSliderGlobals::$table_css);
		$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
		$styles = DestumSliderCssParser::compress_css($styles);
		wp_add_inline_style( 'rs-plugin-settings', $style_pre.$styles.$style_post );

		$custom_css = DestumSliderOperations::getStaticCss();
		$custom_css = DestumSliderCssParser::compress_css($custom_css);
		wp_add_inline_style( 'rs-plugin-settings', $style_pre.$custom_css.$style_post );
		
	}


	/**
	 *
	 * admin main page function.
	 */
	public static function adminPages(){

		parent::adminPages();

		self::setMasterView('master-view');
		self::requireView(self::$view);
		
	}
	

	/**
	 *
	 * import slideer handle (not ajax response)
	 */
	private static function importSliderHandle($viewBack = null, $updateAnim = true, $updateStatic = true, $updateNavigation = true){

		$slider = new DestumSlider();
		$response = $slider->importSliderFromPost($updateAnim, $updateStatic, false, false, false, $updateNavigation);
		
		$sliderID = intval($response["sliderID"]);

		if(empty($viewBack)){
			$viewBack = self::getViewUrl(self::VIEW_SLIDER,"id=".$sliderID);
			if(empty($sliderID))
				$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
		}
		
		//handle error this
		if($response["success"] == false){
			$message = $response["error"];
			DestumSliderOperations::import_failed_message($message, $viewBack);
			
		}else{	//handle success, js redirect.
			//check here to create a page or not
			if(!empty($sliderID)){
				$page_id = 0;
				$page_creation = esc_attr(DestumSliderFunctions::getPostVariable('page-creation'));
				if($page_creation === 'true'){
					$operations = new DestumSliderOperations();
					$page_id = $operations->create_slider_page((array)$sliderID);
				}
				if($page_id > 0){
					echo '<script>window.open("'.get_permalink($page_id).'", "_blank");</script>';
				}
			}
			
			echo "<script>
			location.href='".$viewBack."';
			</script>";
		}
		exit();
	}
	
	
	/**
	 * import slider from TP servers
	 * @since: 5.0.5
	 */
	private static function importSliderOnlineTemplateHandleNew($data, $viewBack = null, $updateAnim = true, $updateStatic = true, $single_slide = false){
		
		$return = array('error' => array(), 'success' => array(), 'open' => false, 'view' => $viewBack);
		
		$uid = esc_attr($data['uid']);
		
		$added = array();
		
		if($uid == ''){
			$return['error'][] = __("ID missing, something went wrong. Please try again!", 'DestumSlider');
		}else{
			$tmp = new DestumSliderTemplate();
			
			$package = esc_attr($data['package']);
			$package = ($package == 'true') ? true : false;
			
			//get all in the same package as the uid
			if($package === true){
				$uids = $tmp->get_package_uids($uid);
			}else{
				$uids = (array)$uid;
			}
			
			if(!empty($uids)){
				foreach($uids as $uid){
					set_time_limit(60); //reset the time limit
			
					$filepath = $tmp->_download_template($uid); //can be single or multiple, depending on $package beeing false or true
					
					//send request to TP server and download file
					if(is_array($filepath) && isset($filepath['error'])){
						$return['error'][] = $filepath['error'];
						break;
					}
					
					if($filepath !== false){
						//check if Slider Template was already imported. If yes, remove the old Slider Template as we now do an "update" (in reality we delete and insert again)
						//get all template sliders
						$tmp_slider = $tmp->getThemePunchTemplateSliders();
						foreach($tmp_slider as $tslider){
							if(isset($tslider['uid']) && $uid == $tslider['uid']){
								if(!isset($tslider['installed'])){ //slider is installed
									//delete template Slider!
									$mSlider = new DestumSlider();
									$mSlider->initByID($tslider['id']);
									
									$mSlider->deleteSlider();
									//remove the update flag from the slider
									
									$tmp->remove_is_new($uid);
								}
								break;
							}
						}
						
						$slider = new DestumSlider();
						$response = $slider->importSliderFromPost($updateAnim, $updateStatic, $filepath, $uid, $single_slide);
						
						$tmp->_delete_template($uid);
						
						if($single_slide === false){
							if(empty($viewBack)){
								$sliderID = $response["sliderID"];
								$viewBack = self::getViewUrl(self::VIEW_SLIDER,"id=".$sliderID);
								$return['view'] = $viewBack;
								if(empty($sliderID)){
									$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
									$return['view'] = $viewBack;
								}
							}
						}
						
						if(isset($response["sliderID"])){
							$return['slider_id'] = $response["sliderID"];
							$added[] = $response["sliderID"];
						}
						//handle error
						if($response["success"] == false){
							$return['error'][] = $response["error"];
							break;
						}else{	//handle success, js redirect.
							$return['success'][] = __("Slider Import Success", 'DestumSlider');
						}
						
					}else{
						if(is_array($filepath)){
							$return['error'][] = $filepath['error'];
						}else{
							$return['error'][] = __("Could not download from server. Please try again later!", 'DestumSlider');
						}
						break;
					}
				}
				
				//check here to create a page or not
				if(!empty($added)){
					$page_creation = esc_attr($data['page-creation']);
					if($page_creation === 'true'){
						$operations = new DestumSliderOperations();
						$page_id = $operations->create_slider_page($added);
					}
					if($page_id > 0){
						$return['open'] = get_permalink($page_id);
					}
				}
			}else{
				$return['error'][] = __("Could not download package. Please try again later!", 'DestumSlider');
			}
		}
		
		return $return;
	}
	
	
	/**
	 * import slider from TP servers
	 * @since: 5.0.5
	 */
	private static function importSliderOnlineTemplateHandle($data, $viewBack = null, $updateAnim = true, $updateStatic = true, $single_slide = false){
		
		$uid = esc_attr($data['uid']);
		
		$added = array();
		
		if($uid == ''){
			$message = __("ID missing, something went wrong. Please try again!", 'DestumSlider');
			DestumSliderOperations::import_failed_message($message, $viewBack);
			exit;
		}else{
			$tmp = new DestumSliderTemplate();
			
			$package = esc_attr($data['package']);
			$package = ($package == 'true') ? true : false;
			
			//get all in the same package as the uid
			if($package === true){
				$uids = $tmp->get_package_uids($uid);
			}else{
				$uids = (array)$uid;
			}
			
			if(!empty($uids)){
				foreach($uids as $uid){
					set_time_limit(60); //reset the time limit
			
					$filepath = $tmp->_download_template($uid); //can be single or multiple, depending on $package beeing false or true
					//var_dump($filepath);
					//exit;
					//send request to TP server and download file
					if(is_array($filepath) && isset($filepath['error'])){
						$message = $filepath['error'];
						DestumSliderOperations::import_failed_message($message, $viewBack);
						exit;
					}
					
					if($filepath !== false){
						//check if Slider Template was already imported. If yes, remove the old Slider Template as we now do an "update" (in reality we delete and insert again)
						//get all template sliders
						$tmp_slider = $tmp->getThemePunchTemplateSliders();
						
						foreach($tmp_slider as $tslider){
							if(isset($tslider['uid']) && $uid == $tslider['uid']){
								if(!isset($tslider['installed'])){ //slider is installed
									//delete template Slider!
									$mSlider = new DestumSlider();
									$mSlider->initByID($tslider['id']);
									
									$mSlider->deleteSlider();
									//remove the update flag from the slider
									
									$tmp->remove_is_new($uid);
								}
								break;
							}
						}
						
						
						$slider = new DestumSlider();
						$response = $slider->importSliderFromPost($updateAnim, $updateStatic, $filepath, $uid, $single_slide);
						
						$tmp->_delete_template($uid);
						
						if($single_slide === false){
							if(empty($viewBack)){
								$sliderID = $response["sliderID"];
								$viewBack = self::getViewUrl(self::VIEW_SLIDER,"id=".$sliderID);
								if(empty($sliderID))
									$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
							}
						}
						
						if(isset($response["sliderID"])){
							$added[] = $response["sliderID"];
						}
						//handle error
						if($response["success"] == false){
							$message = $response["error"];
							DestumSliderOperations::import_failed_message($message, $viewBack);
						}else{	//handle success, js redirect.
						
						}
						
					}else{
						if(is_array($filepath)){
							$message = $filepath['error'];
						}else{
							$message = __("Could not download from server. Please try again later!", 'DestumSlider');
						}
						DestumSliderOperations::import_failed_message($message, $viewBack);
						exit;
					}
				}
				
				//check here to create a page or not
				if(!empty($added)){
					$page_creation = esc_attr($data['page-creation']);
					if($page_creation === 'true'){
						$operations = new DestumSliderOperations();
						$page_id = $operations->create_slider_page($added);
					}
					if($page_id > 0){
						echo '<script>window.open("'.get_permalink($page_id).'", "_blank");</script>';
					}
				}
				
				echo "<script>location.href='".$viewBack."';</script>";
			}else{
				$message = __("Could not download package. Please try again later!", 'DestumSlider');
				DestumSliderOperations::import_failed_message($message, $viewBack);
				exit;
			}
		}
		
		exit;
	}
	
	
	/**
	 *
	 * import slider handle (not ajax response)
	 */
	private static function importSliderTemplateHandle($viewBack = null, $updateAnim = true, $updateStatic = true, $single_slide = false){
		
		$uid = esc_attr(DestumSliderFunctions::getPostVariable('uid'));
		if($uid == ''){
			$message = __("ID missing, something went wrong. Please try again!", 'DestumSlider');
			DestumSliderOperations::import_failed_message($message, $viewBack);
			exit;
		}
		
		//check if the filename is correct
		//import to templates, then duplicate Slider
		
		$slider = new DestumSlider();
		$response = $slider->importSliderFromPost($updateAnim, $updateStatic, false, $uid, $single_slide);
		
		if($single_slide === false){
			$sliderID = $response["sliderID"];
			if(empty($viewBack)){
				$viewBack = self::getViewUrl(self::VIEW_SLIDER,"id=".$sliderID);
				if(empty($sliderID))
					$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
			}
		}

		//handle error
		if($response["success"] == false){
			$message = $response["error"];
			DestumSliderOperations::import_failed_message($message, $viewBack);
		}else{	//handle success, js redirect.
			//check here to create a page or not
			if(isset($sliderID) && !empty($sliderID)){
				$page_creation = esc_attr(DestumSliderFunctions::getPostVariable('page-creation'));
				if($page_creation === 'true'){
					$operations = new DestumSliderOperations();
					$page_id = $operations->create_slider_page((array)$sliderID);
				}
				if($page_id > 0){
					echo '<script>window.open("'.get_permalink($page_id).'", "_blank");</script>';
				}
			}
			
			echo "<script>location.href='".$viewBack."';</script>";
		}
		
		exit();
	}

	/**
	 * Get url to secific view.
	 */
	public static function getFontsUrl(){

		$link = admin_url('admin.php?page=themepunch-google-fonts');
		return($link);
	}
	
	
	/**
	 * Toggle Favorite State of Slider
	 * @since: 5.0
	 */
	public static function toggle_favorite_by_id($id){
		$id = intval($id);
		if($id === 0) return false;
		
		global $wpdb;
		
		$table_name = $wpdb->prefix . DestumSliderGlobals::TABLE_SLIDERS_NAME;
		
		//check if ID exists
		$slider = $wpdb->get_row($wpdb->prepare("SELECT settings FROM $table_name WHERE id = %s", $id), ARRAY_A);
		
		if(empty($slider))
			return __('Slider not found', 'DestumSlider');
			
		$settings = json_decode($slider['settings'], true);
		
		if(!isset($settings['favorite']) || $settings['favorite'] == 'false' || $settings['favorite'] == false){
			$settings['favorite'] = 'true';
		}else{
			$settings['favorite'] = 'false';
		}
		
		$response = $wpdb->update($table_name, array('settings' => json_encode($settings)), array('id' => $id));
		
		if($response === false) return __('Slider setting could not be changed', 'DestumSlider');
		
		return true;
	}

	/**
	 *
	 * onAjax action handler
	 */
	public static function onAjaxAction(){
		
		$role = self::getMenuRole(); //add additional security check and allow for example import only for admin
		
		$slider = new DestumSlider();
		$slide = new RevSlide();
		$operations = new DestumSliderOperations();

		$action = self::getPostGetVar("client_action");
		$data = self::getPostGetVar("data");
		if($data == '') $data = array();
		$nonce = self::getPostGetVar("nonce");
		if(empty($nonce))
			$nonce = self::getPostGetVar("rs-nonce");
		
		try{
			
			if(RS_DEMO){
				switch($action){
					case 'import_slider_online_template_slidersview':
					case 'duplicate_slider':
					case 'preview_slider':
					case 'get_static_css':
					case 'get_dynamic_css':
					case 'preview_slide':
						//these are all okay in demo mode
					break;
					default:
						DestumSliderFunctions::throwError(__('Function Not Available in Demo Mode', 'DestumSlider'));
						exit;
					break;
				}
			}
			
			if(!DestumSliderFunctionsWP::isAdminUser() && apply_filters('DestumSlider_restrict_role', true)){
				switch($action){
					case 'change_specific_navigation':
					case 'change_navigations':
					case 'update_static_css':
					case 'add_new_preset':
					case 'update_preset':
					case 'import_slider':
					case 'import_slider_slidersview':
					case 'import_slider_template_slidersview':
					case 'import_slide_template_slidersview':
					case 'import_slider_online_template_slidersview_new':
					case 'fix_database_issues':
						DestumSliderFunctions::throwError(__('Function Only Available for Adminstrators', 'DestumSlider'));
						exit;
					break;
					default:
						$return = apply_filters('DestumSlider_admin_onAjaxAction_user_restriction', true, $action, $data, $slider, $slide, $operations);
						if($return !== true){
							DestumSliderFunctions::throwError(__('Function Only Available for Adminstrators', 'DestumSlider'));
							exit;
						}
					break;
				}
			}
			
			//verify the nonce
			$isVerified = wp_verify_nonce($nonce, "DestumSlider_actions");

			if($isVerified == false){
				DestumSliderFunctions::throwError("Wrong request");
				exit;
			}
			switch($action){
				case 'add_new_preset':
					
					if(!isset($data['settings']) || !isset($data['values'])) self::ajaxResponseError(__('Missing values to add preset', 'DestumSlider'), false);
					
					$result = $operations->add_preset_setting($data);
					
					if($result === true){
						
						$presets = $operations->get_preset_settings();
						
						self::ajaxResponseSuccess(__('Preset created', 'DestumSlider'), array('data' => $presets));
					}else{
						self::ajaxResponseError($result, false);
					}
					
					exit;
				break;
				case 'update_preset':
					if(!isset($data['name']) || !isset($data['values'])) self::ajaxResponseError(__('Missing values to update preset', 'DestumSlider'), false);
					
					$result = $operations->update_preset_setting($data);
					
					if($result === true){
						
						$presets = $operations->get_preset_settings();
						
						self::ajaxResponseSuccess(__('Preset created', 'DestumSlider'), array('data' => $presets));
					}else{
						self::ajaxResponseError($result, false);
					}
					
					exit;
				break;
				case 'remove_preset':
					if(!isset($data['name'])) self::ajaxResponseError(__('Missing values to remove preset', 'DestumSlider'), false);
					
					$result = $operations->remove_preset_setting($data);
					
					if($result === true){
						
						$presets = $operations->get_preset_settings();
						
						self::ajaxResponseSuccess(__('Preset deleted', 'DestumSlider'), array('data' => $presets));
					}else{
						self::ajaxResponseError($result, false);
					}
					
					exit;
				break;
				case "export_slider":
					$sliderID = self::getGetVar("sliderid");
					$dummy = self::getGetVar("dummy");
					$slider->initByID($sliderID);
					$slider->exportSlider($dummy);
				break;
				case "import_slider":
					$updateAnim = self::getPostGetVar("update_animations");
					$updateNav = self::getPostGetVar("update_navigations");
					//$updateStatic = self::getPostGetVar("update_static_captions");
					$updateStatic = 'none';
					self::importSliderHandle(null, $updateAnim, $updateStatic, $updateNav);
				break;
				case "import_slider_slidersview":
					$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
					$updateAnim = self::getPostGetVar("update_animations");
					$updateNav = self::getPostGetVar("update_navigations");
					//$updateStatic = self::getPostGetVar("update_static_captions");
					$updateStatic = 'none';
					self::importSliderHandle($viewBack, $updateAnim, $updateStatic, $updateNav);
				break;
				case "import_slider_online_template_slidersview":
					$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
					//ob_start();
					$data['uid'] = esc_attr(DestumSliderFunctions::getPostVariable('uid'));
					$data['page-creation'] = esc_attr(DestumSliderFunctions::getPostVariable('page-creation'));
					$data['package'] = esc_attr(DestumSliderFunctions::getPostVariable('package'));
					
					self::importSliderOnlineTemplateHandle($data, $viewBack, 'true', 'none');
					/*$html = ob_get_contents();
					ob_clean();
					ob_end_clean();
					
					self::ajaxResponseData($html);*/
				break;
				case "import_slider_template_slidersview":
					$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
					$updateAnim = self::getPostGetVar("update_animations");
					//$updateStatic = self::getPostGetVar("update_static_captions");
					$updateStatic = 'none';
					self::importSliderTemplateHandle($viewBack, $updateAnim, $updateStatic);
				break;
				case "import_slider_online_template_slidersview_new":
					$viewBack = self::getViewUrl(self::VIEW_SLIDERS);
					$response = self::importSliderOnlineTemplateHandleNew($data, $viewBack, 'true', 'none');
					self::ajaxResponseData($response);
				break;
				case 'create_draft_page':
					$response = array('open' => false);
					
					$page_id = $operations->create_slider_page($data['slider_ids']);
					if($page_id > 0){
						$response['open'] = get_permalink($page_id);
					}
					self::ajaxResponseData($response);
				break;
				case "import_slide_online_template_slidersview":
					$redirect_id = esc_attr(self::getPostGetVar("redirect_id"));
					$viewBack = self::getViewUrl(self::VIEW_SLIDE,"id=$redirect_id");
					$slidenum = intval(self::getPostGetVar("slidenum"));
					$sliderid = intval(self::getPostGetVar("slider_id"));
					
					$data['uid'] = esc_attr(DestumSliderFunctions::getPostVariable('uid'));
					$data['page-creation'] = esc_attr(DestumSliderFunctions::getPostVariable('page-creation'));
					$data['package'] = esc_attr(DestumSliderFunctions::getPostVariable('package'));
					
					self::importSliderOnlineTemplateHandle($data, $viewBack, 'true', 'none', array('slider_id' => $sliderid, 'slide_id' => $slidenum));
				break;
				case "import_slide_template_slidersview":
					$redirect_id = esc_attr(self::getPostGetVar("redirect_id"));
					$viewBack = self::getViewUrl(self::VIEW_SLIDE,"id=$redirect_id");
					$updateAnim = self::getPostGetVar("update_animations");
					//$updateStatic = self::getPostGetVar("update_static_captions");
					$updateStatic = 'none';
					$slidenum = intval(self::getPostGetVar("slidenum"));
					$sliderid = intval(self::getPostGetVar("slider_id"));
					
					self::importSliderTemplateHandle($viewBack, $updateAnim, $updateStatic, array('slider_id' => $sliderid, 'slide_id' => $slidenum));
				break;
				case "create_slider":
					$data = $operations->modifyCustomSliderParams($data);
					$newSliderID = $slider->createSliderFromOptions($data);
					self::ajaxResponseSuccessRedirect(__("Slider created",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDE, 'id=new&slider='.esc_attr($newSliderID))); //redirect to slide now

				break;
				case "update_slider":
					$data = $operations->modifyCustomSliderParams($data);
					$slider->updateSliderFromOptions($data);
					self::ajaxResponseSuccess(__("Slider updated",'DestumSlider'));
				break;
				case "delete_slider":
				case "delete_slider_stay":

					$isDeleted = $slider->deleteSliderFromData($data);

					if(is_array($isDeleted)){
						$isDeleted = implode(', ', $isDeleted);
						self::ajaxResponseError(__("Template can't be deleted, it is still being used by the following Sliders: ", 'DestumSlider').$isDeleted);
					}else{
						if($action == 'delete_slider_stay'){
							self::ajaxResponseSuccess(__("Slider deleted",'DestumSlider'));
						}else{
							self::ajaxResponseSuccessRedirect(__("Slider deleted",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDERS));
						}
					}
				break;
				case "duplicate_slider":

					$slider->duplicateSliderFromData($data);

					self::ajaxResponseSuccessRedirect(__("Success! Refreshing page...",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDERS));
				break;
				case "duplicate_slider_package":

					$ret = $slider->duplicateSliderPackageFromData($data);
					
					if($ret !== true){
						DestumSliderFunctions::throwError($ret);
					}else{
						self::ajaxResponseSuccessRedirect(__("Success! Refreshing page...",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDERS));
					}
				break;
				case "add_slide":
				case "add_bulk_slide":
					$numSlides = $slider->createSlideFromData($data);
					$sliderID = $data["sliderid"];

					if($numSlides == 1){
						$responseText = __("Slide Created",'DestumSlider');
					}else{
						$responseText = $numSlides . " ".__("Slides Created",'DestumSlider');
					}

					$urlRedirect = self::getViewUrl(self::VIEW_SLIDE,"id=new&slider=$sliderID");
					self::ajaxResponseSuccessRedirect($responseText,$urlRedirect);

				break;
				case "add_slide_fromslideview":
					$slideID = $slider->createSlideFromData($data,true);
					$urlRedirect = self::getViewUrl(self::VIEW_SLIDE,"id=$slideID");
					$responseText = __("Slide Created, redirecting...",'DestumSlider');
					self::ajaxResponseSuccessRedirect($responseText,$urlRedirect);
				break;
				case 'copy_slide_to_slider':
					$slideID = (isset($data['redirect_id'])) ? $data['redirect_id'] : -1;
					
					if($slideID === -1) DestumSliderFunctions::throwError(__('Missing redirect ID!', 'DestumSlider'));
					
					$return = $slider->copySlideToSlider($data);
					
					if($return !== true) DestumSliderFunctions::throwError($return);
					
					$urlRedirect = self::getViewUrl(self::VIEW_SLIDE,"id=$slideID");
					$responseText = __("Slide copied to current Slider, redirecting...",'DestumSlider');
					self::ajaxResponseSuccessRedirect($responseText,$urlRedirect);
				break;
				case 'update_slide':
					if(isset($data['obj_favorites'])){
						$obj_favorites = $data['obj_favorites'];
						unset($data['obj_favorites']);
						//save object favourites
						$objlib = new DestumSliderObjectLibrary();
						$objlib->save_favorites($obj_favorites);
					}
					$slide->updateSlideFromData($data);
					self::ajaxResponseSuccess(__("Slide updated",'DestumSlider'));
				break;
				case "update_static_slide":
					if(isset($data['obj_favorites'])){
						$obj_favorites = $data['obj_favorites'];
						unset($data['obj_favorites']);
						//save object favourites
						$objlib = new DestumSliderObjectLibrary();
						$objlib->save_favorites($obj_favorites);
					}
					$slide->updateStaticSlideFromData($data);
					self::ajaxResponseSuccess(__("Static Global Layers updated",'DestumSlider'));
				break;
				case "delete_slide":
				case "delete_slide_stay":
					$isPost = $slide->deleteSlideFromData($data);
					if($isPost)
						$message = __("Post deleted",'DestumSlider');
					else
						$message = __("Slide deleted",'DestumSlider');

					$sliderID = DestumSliderFunctions::getVal($data, "sliderID");
					if($action == 'delete_slide_stay'){
						self::ajaxResponseSuccess($message);
					}else{
						self::ajaxResponseSuccessRedirect($message, self::getViewUrl(self::VIEW_SLIDE,"id=new&slider=$sliderID"));
					}
				break;
				case "duplicate_slide":
				case "duplicate_slide_stay":
					$return = $slider->duplicateSlideFromData($data);
					if($action == 'duplicate_slide_stay'){
						self::ajaxResponseSuccess(__("Slide duplicated",'DestumSlider'), array('id' => $return[1]));
					}else{
						self::ajaxResponseSuccessRedirect(__("Slide duplicated",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDE,"id=new&slider=".$return[0]));
					}
				break;
				case "copy_move_slide":
				case "copy_move_slide_stay":
					$sliderID = $slider->copyMoveSlideFromData($data);
					if($action == 'copy_move_slide_stay'){
						self::ajaxResponseSuccess(__("Success!",'DestumSlider'));
					}else{
						self::ajaxResponseSuccessRedirect(__("Success! Refreshing page...",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDE,"id=new&slider=$sliderID"));
					}
				break;
				case "add_slide_to_template":
					$template = new DestumSliderTemplate();
					if(!isset($data['slideID']) || intval($data['slideID']) == 0){
						DestumSliderFunctions::throwError(__('No valid Slide ID given', 'DestumSlider'));
						exit;
					}
					if(!isset($data['title']) || strlen(trim($data['title'])) < 3){
						DestumSliderFunctions::throwError(__('No valid title given', 'DestumSlider'));
						exit;
					}
					if(!isset($data['settings']) || !isset($data['settings']['width']) || !isset($data['settings']['height'])){
						DestumSliderFunctions::throwError(__('No valid title given', 'DestumSlider'));
						exit;
					}
					
					$return = $template->copySlideToTemplates($data['slideID'], $data['title'], $data['settings']);
					
					if($return == false){
						DestumSliderFunctions::throwError(__('Could not save Slide as Template', 'DestumSlider'));
						exit;
					}
					
					//get HTML for template section
					ob_start();
					
					$rs_disable_template_script = true; //disable the script output of template selector file
					
					include(RS_PLUGIN_PATH.'admin/views/templates/template-selector.php');
					
					$html = ob_get_contents();
					
					ob_clean();
					ob_end_clean();
					
					self::ajaxResponseSuccess(__('Slide added to Templates', 'DestumSlider'),array('HTML' => $html));
					exit;
				break;
				case "get_slider_custom_css_js":
					$slider_css = '';
					$slider_js = '';
					if(isset($data['slider_id']) && intval($data['slider_id']) > 0){
						$slider->initByID(intval($data['slider_id']));
						$slider_css = stripslashes($slider->getParam('custom_css', ''));
						$slider_js = stripslashes($slider->getParam('custom_javascript', ''));
					}
					self::ajaxResponseData(array('css' => $slider_css, 'js' => $slider_js));
				break;
				case "update_slider_custom_css_js":
					if(isset($data['slider_id']) && intval($data['slider_id']) > 0){
						$slider->initByID(intval($data['slider_id']));
						$slider->updateParam(array('custom_css' => $data['css']));
						$slider->updateParam(array('custom_javascript' => $data['js']));
					}
					self::ajaxResponseSuccess(__('Slider CSS saved', 'DestumSlider'));
					exit;
				break;
				case "get_static_css":
					$contentCSS = $operations->getStaticCss();
					self::ajaxResponseData($contentCSS);
				break;
				case "get_dynamic_css":
					$contentCSS = $operations->getDynamicCss();
					self::ajaxResponseData($contentCSS);
				break;
				case "insert_captions_css":
					
					$arrCaptions = $operations->insertCaptionsContentData($data);
					
					if($arrCaptions !== false){
						$db = new DestumSliderDB();
						$styles = $db->fetch(DestumSliderGlobals::$table_css);
						$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
						$styles = DestumSliderCssParser::compress_css($styles);
						$custom_css = DestumSliderOperations::getStaticCss();
						$custom_css = DestumSliderCssParser::compress_css($custom_css);
						
						$arrCSS = $operations->getCaptionsContentArray();
						$arrCssStyles = DestumSliderFunctions::jsonEncodeForClientSide($arrCSS);
						$arrCssStyles = $arrCSS;
						
						self::ajaxResponseSuccess(__("CSS saved",'DestumSlider'),array("arrCaptions"=>$arrCaptions,'compressed_css'=>$styles.$custom_css,'initstyles'=>$arrCssStyles));
					}
					
					DestumSliderFunctions::throwError(__('CSS could not be saved', 'DestumSlider'));
					exit();
				break;
				case "update_captions_css":
					$arrCaptions = $operations->updateCaptionsContentData($data);
					
					//now check all layers of all sliders and check if you need to change them (only if all values are default)
					
					
					if($arrCaptions !== false){
						$db = new DestumSliderDB();
						$styles = $db->fetch(DestumSliderGlobals::$table_css);
						$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
						$styles = DestumSliderCssParser::compress_css($styles);
						$custom_css = DestumSliderOperations::getStaticCss();
						$custom_css = DestumSliderCssParser::compress_css($custom_css);
						
						$arrCSS = $operations->getCaptionsContentArray();
						$arrCssStyles = DestumSliderFunctions::jsonEncodeForClientSide($arrCSS);
						$arrCssStyles = $arrCSS;
						
						self::ajaxResponseSuccess(__("CSS saved",'DestumSlider'),array("arrCaptions"=>$arrCaptions,'compressed_css'=>$styles.$custom_css,'initstyles'=>$arrCssStyles));
					}
					
					DestumSliderFunctions::throwError(__('CSS could not be saved', 'DestumSlider'));
					exit();
				break;
				case "update_captions_advanced_css":
					
					$arrCaptions = $operations->updateAdvancedCssData($data);
					if($arrCaptions !== false){
						$db = new DestumSliderDB();
						$styles = $db->fetch(DestumSliderGlobals::$table_css);
						$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
						$styles = DestumSliderCssParser::compress_css($styles);
						$custom_css = DestumSliderOperations::getStaticCss();
						$custom_css = DestumSliderCssParser::compress_css($custom_css);
						
						$arrCSS = $operations->getCaptionsContentArray();
						$arrCssStyles = DestumSliderFunctions::jsonEncodeForClientSide($arrCSS);
						$arrCssStyles = $arrCSS;
						
						self::ajaxResponseSuccess(__("CSS saved",'DestumSlider'),array("arrCaptions"=>$arrCaptions,'compressed_css'=>$styles.$custom_css,'initstyles'=>$arrCssStyles));
					}
					
					DestumSliderFunctions::throwError(__('CSS could not be saved', 'DestumSlider'));
					exit();
				break;
				case "rename_captions_css":
					//rename all captions in all sliders with new handle if success
					$arrCaptions = $operations->renameCaption($data);
					
					$db = new DestumSliderDB();
					$styles = $db->fetch(DestumSliderGlobals::$table_css);
					$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
					$styles = DestumSliderCssParser::compress_css($styles);
					$custom_css = DestumSliderOperations::getStaticCss();
					$custom_css = DestumSliderCssParser::compress_css($custom_css);
					
					$arrCSS = $operations->getCaptionsContentArray();
					$arrCssStyles = DestumSliderFunctions::jsonEncodeForClientSide($arrCSS);
					$arrCssStyles = $arrCSS;
					
					self::ajaxResponseSuccess(__("Class name renamed",'DestumSlider'),array("arrCaptions"=>$arrCaptions,'compressed_css'=>$styles.$custom_css,'initstyles'=>$arrCssStyles));
				break;
				case "delete_captions_css":
					$arrCaptions = $operations->deleteCaptionsContentData($data);
					
					$db = new DestumSliderDB();
					$styles = $db->fetch(DestumSliderGlobals::$table_css);
					$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
					$styles = DestumSliderCssParser::compress_css($styles);
					$custom_css = DestumSliderOperations::getStaticCss();
					$custom_css = DestumSliderCssParser::compress_css($custom_css);
					
					$arrCSS = $operations->getCaptionsContentArray();
					$arrCssStyles = DestumSliderFunctions::jsonEncodeForClientSide($arrCSS);
					$arrCssStyles = $arrCSS;
					
					self::ajaxResponseSuccess(__("Style deleted!",'DestumSlider'),array("arrCaptions"=>$arrCaptions,'compressed_css'=>$styles.$custom_css,'initstyles'=>$arrCssStyles));
				break;
				case "update_static_css":
					$data = ''; //do not allow to add new global CSS anymore, instead, remove all!
					$staticCss = $operations->updateStaticCss($data);
					
					$db = new DestumSliderDB();
					$styles = $db->fetch(DestumSliderGlobals::$table_css);
					$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
					$styles = DestumSliderCssParser::compress_css($styles);
					$custom_css = DestumSliderOperations::getStaticCss();
					$custom_css = DestumSliderCssParser::compress_css($custom_css);
					
					self::ajaxResponseSuccess(__("CSS saved",'DestumSlider'),array("css"=>$staticCss,'compressed_css'=>$styles.$custom_css));
				break;
				case "insert_custom_anim":
					$arrAnims = $operations->insertCustomAnim($data); //$arrCaptions =
					self::ajaxResponseSuccess(__("Animation saved",'DestumSlider'), $arrAnims); //,array("arrCaptions"=>$arrCaptions)
				break;
				case "update_custom_anim":
					$arrAnims = $operations->updateCustomAnim($data);
					self::ajaxResponseSuccess(__("Animation saved",'DestumSlider'), $arrAnims); //,array("arrCaptions"=>$arrCaptions)
				break;
				case "update_custom_anim_name":
					$arrAnims = $operations->updateCustomAnimName($data);
					self::ajaxResponseSuccess(__("Animation saved",'DestumSlider'), $arrAnims); //,array("arrCaptions"=>$arrCaptions)
				break;
				case "delete_custom_anim":
					$arrAnims = $operations->deleteCustomAnim($data);
					self::ajaxResponseSuccess(__("Animation deleted",'DestumSlider'), $arrAnims); //,array("arrCaptions"=>$arrCaptions)
				break;
				case "update_slides_order":
					$slider->updateSlidesOrderFromData($data);
					self::ajaxResponseSuccess(__("Order updated",'DestumSlider'));
				break;
				case "change_slide_title":
					$slide->updateTitleByID($data);
					self::ajaxResponseSuccess(__('Title updated','DestumSlider'));
				break;
				case "change_slide_image":
					$slide->updateSlideImageFromData($data);
					$sliderID = DestumSliderFunctions::getVal($data, "slider_id");
					self::ajaxResponseSuccessRedirect(__("Slide changed",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDE,"id=new&slider=$sliderID"));
				break;
				case "preview_slide":
					$operations->putSlidePreviewByData($data);
					exit;
				break;
				case "preview_slider":
					$sliderID = DestumSliderFunctions::getPostGetVariable("sliderid");
					$do_markup = DestumSliderFunctions::getPostGetVariable("only_markup");

					if($do_markup == 'true')
						$operations->previewOutputMarkup($sliderID);
					else
						$operations->previewOutput($sliderID);
					
					exit;
				break;
				case "get_import_slides_data":
					$slides = array();
					if(!is_array($data)){
						$slider->initByID(intval($data));
						
						$full_slides = $slider->getSlides(); //static slide is missing
						
						if(!empty($full_slides)){
							foreach($full_slides as $slide_id => $mslide){
								$slides[$slide_id]['layers'] = $mslide->getLayers();
								foreach($slides[$slide_id]['layers'] as $k => $l){ //remove columns as they can not be imported
									if(isset($l['type']) && ($l['type'] == 'column' || $l['type'] == 'row' || $l['type'] == 'group')) unset($slides[$slide_id]['layers'][$k]);
								}
								$slides[$slide_id]['params'] = $mslide->getParams();
							}
						}
						
						$staticID = $slide->getStaticSlideID($slider->getID());
						if($staticID !== false){
							$msl = new DestumSliderSlide();
							if(strpos($staticID, 'static_') === false){
								$staticID = 'static_'.$slider->getID();
							}
							$msl->initByID($staticID);
							if($msl->getID() !== ''){
								$slides[$msl->getID()]['layers'] = $msl->getLayers();
								foreach($slides[$msl->getID()]['layers'] as $k => $l){ //remove columns as they can not be imported
									if(isset($l['type']) && ($l['type'] == 'column' || $l['type'] == 'row' || $l['type'] == 'group')) unset($slides[$msl->getID()]['layers'][$k]);
								}
								$slides[$msl->getID()]['params'] = $msl->getParams();
								$slides[$msl->getID()]['params']['title'] = __('Static Slide', 'DestumSlider');
							}
						}
					}
					if(!empty($slides)){
						self::ajaxResponseData(array('slides' => $slides));
					}else{
						self::ajaxResponseData('');
					}
				break;
				case "create_navigation_preset":
					$nav = new DestumSliderNavigation();
					
					$return = $nav->add_preset($data);
					
					if($return === true){
						self::ajaxResponseSuccess(__('Navigation preset saved/updated', 'DestumSlider'), array('navs' => $nav->get_all_navigations()));
					}else{
						if($return === false) $return = __('Preset could not be saved/values are the same', 'DestumSlider');
						self::ajaxResponseError($return);
					}
				break;
				case "delete_navigation_preset":
					$nav = new DestumSliderNavigation();
					
					$return = $nav->delete_preset($data);
					
					if($return){
						self::ajaxResponseSuccess(__('Navigation preset deleted', 'DestumSlider'), array('navs' => $nav->get_all_navigations()));
					}else{
						if($return === false) $return = __('Preset not found', 'DestumSlider');
						self::ajaxResponseError($return);
					}
				break;
				case "toggle_slide_state":
					$currentState = $slide->toggleSlideStatFromData($data);
					self::ajaxResponseData(array("state"=>$currentState));
				break;
				case "toggle_hero_slide":
					$currentHero = $slider->setHeroSlide($data);
					self::ajaxResponseSuccess(__('Slide is now the new active Hero Slide', 'DestumSlider'));
				break;
				case "slide_lang_operation":
					$responseData = $slide->doSlideLangOperation($data);
					self::ajaxResponseData($responseData);
				break;
				case "update_general_settings":
					$operations->updateGeneralSettings($data);
					self::ajaxResponseSuccess(__("General settings updated",'DestumSlider'));
				break;
				case "fix_database_issues":
					update_option('DestumSlider_change_database', true);
					DestumSliderFront::createDBTables();
					
					self::ajaxResponseSuccess(__('Database structure creation/update done','DestumSlider'));
				break;
				case "update_posts_sortby":
					$slider->updatePostsSortbyFromData($data);
					self::ajaxResponseSuccess(__("Sortby updated",'DestumSlider'));
				break;
				case "replace_image_urls":
					$slider->replaceImageUrlsFromData($data);
					self::ajaxResponseSuccess(__("All Urls replaced",'DestumSlider'));
				break;
				case "reset_slide_settings":
					$slider->resetSlideSettings($data);
					self::ajaxResponseSuccess(__("Settings in all Slides changed",'DestumSlider'));
				break;
				case "delete_template_slide":
				
					$slideID = (isset($data['slide_id'])) ? $data['slide_id'] : -1;
					
					if($slideID === -1) DestumSliderFunctions::throwError(__('Missing Slide ID!', 'DestumSlider'));
					
					$slide->initByID($slideID);
					$slide->deleteSlide();
					
					$responseText = __("Slide deleted",'DestumSlider');
					self::ajaxResponseSuccess($responseText);
				break;
				case "activate_purchase_code":
					$result = false;
					if(!empty($data['code'])){ // && !empty($data['email'])
						$result = $operations->checkPurchaseVerification($data);
					}else{
						DestumSliderFunctions::throwError(__('The Purchase Code and the E-Mail address need to be set!', 'DestumSlider'));
						exit();
					}

					if($result === true){
						self::ajaxResponseSuccessRedirect(__("Purchase Code Successfully Activated",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDERS));
					}elseif($result === false){
						DestumSliderFunctions::throwError(__('Purchase Code is invalid', 'DestumSlider'));
					}else{
						if($result == 'temp'){
							self::ajaxResponseSuccessRedirect(__("Purchase Code Temporary Activated",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDERS));
						}
						if($result == 'exist'){
							self::ajaxResponseData(array('error'=>$result,'msg'=> __('Purchase Code already registered!', 'DestumSlider')));
						}
						/*elseif($result == 'bad_email'){
							DestumSliderFunctions::throwError(__('Please add an valid E-Mail Address', 'DestumSlider'));
						}elseif($result == 'email_used'){
							DestumSliderFunctions::throwError(__('E-Mail already in use, please choose a different E-Mail', 'DestumSlider'));
						}*/
						DestumSliderFunctions::throwError(__('Purchase Code could not be validated', 'DestumSlider'));
					}
				break;
				case "deactivate_purchase_code":
					$result = $operations->doPurchaseDeactivation($data);

					if($result){
						self::ajaxResponseSuccessRedirect(__("Successfully removed validation",'DestumSlider'), self::getViewUrl(self::VIEW_SLIDERS));
					}else{
						DestumSliderFunctions::throwError(__('Could not remove Validation!', 'DestumSlider'));
					}
				break;
				case 'dismiss_notice':
					update_option('DestumSlider-valid-notice', 'false');
					self::ajaxResponseSuccess(__(".",'DestumSlider'));
				break;
				case 'dismiss_dynamic_notice':
					if(trim($data['id']) == 'DISCARD'){
						update_option('DestumSlider-deact-notice', false);
					}elseif(trim($data['id']) == 'DISCARDTEMPACT'){
						update_option('DestumSlider-temp-active-notice', 'false');
					}else{
						$notices_discarded = get_option('DestumSlider-notices-dc', array());
						$notices_discarded[] = esc_attr(trim($data['id']));
						update_option('DestumSlider-notices-dc', $notices_discarded);
					}
					
					self::ajaxResponseSuccess(__(".",'DestumSlider'));
				break;
				case 'toggle_favorite':
					if(isset($data['id']) && intval($data['id']) > 0){
						$return = self::toggle_favorite_by_id($data['id']);
						if($return === true){
							self::ajaxResponseSuccess(__('Setting Changed!', 'DestumSlider'));
						}else{
							$error = $return;
						}	
					}else{
						$error = __('No ID given', 'DestumSlider');
					}
					self::ajaxResponseError($error);
				break;
				case "subscribe_to_newsletter":
					if(isset($data['email']) && !empty($data['email'])){
						$return = ThemePunch_Newsletter::subscribe($data['email']);
						
						if($return !== false){
							if(!isset($return['status']) || $return['status'] === 'error'){
								$error = (isset($return['message']) && !empty($return['message'])) ? $return['message'] : __('Invalid Email', 'DestumSlider');
								self::ajaxResponseError($error);
							}else{
								self::ajaxResponseSuccess(__("Success! Please check your Emails to finish the subscription", 'DestumSlider'), $return);
							}
						}else{
							self::ajaxResponseError(__('Invalid Email/Could not connect to the Newsletter server', 'DestumSlider'));
						}	
					}else{
						self::ajaxResponseError(__('No Email given', 'DestumSlider'));
					}
				break;
				case "unsubscribe_to_newsletter":
					if(isset($data['email']) && !empty($data['email'])){
						$return = ThemePunch_Newsletter::unsubscribe($data['email']);
						
						if($return !== false){
							if(!isset($return['status']) || $return['status'] === 'error'){
								$error = (isset($return['message']) && !empty($return['message'])) ? $return['message'] : __('Invalid Email', 'DestumSlider');
								self::ajaxResponseError($error);
							}else{
								self::ajaxResponseSuccess(__("Success! Please check your Emails to finish the process", 'DestumSlider'), $return);
							}
						}else{
							self::ajaxResponseError(__('Invalid Email/Could not connect to the Newsletter server', 'DestumSlider'));
						}	
					}else{
						self::ajaxResponseError(__('No Email given', 'DestumSlider'));
					}
				break;
				case 'change_specific_navigation':
					$nav = new DestumSliderNavigation();
					
					$found = false;
					$navigations = $nav->get_all_navigations();
					foreach($navigations as $navig){
						if($data['id'] == $navig['id']){
							$found = true;
							break;
						}
					}
					if($found){
						$nav->create_update_navigation($data, $data['id']);
					}else{
						$nav->create_update_navigation($data);
					}
					
					self::ajaxResponseSuccess(__('Navigation saved/updated', 'DestumSlider'), array('navs' => $nav->get_all_navigations()));
					
				break;
				case 'change_navigations':
					$nav = new DestumSliderNavigation();
					
					$nav->create_update_full_navigation($data);
					
					self::ajaxResponseSuccess(__('Navigations updated', 'DestumSlider'), array('navs' => $nav->get_all_navigations()));
				break;
				case 'delete_navigation':
					$nav = new DestumSliderNavigation();
					
					if(isset($data) && intval($data) > 0){
						$return = $nav->delete_navigation($data);
						
						if($return !== true){
							self::ajaxResponseError($return);
						}else{
							self::ajaxResponseSuccess(__('Navigation deleted', 'DestumSlider'), array('navs' => $nav->get_all_navigations()));
						}
					}
					
					self::ajaxResponseError(__('Wrong ID given', 'DestumSlider'));
				break;
				case "get_facebook_photosets":
					if(!empty($data['url'])){
						$facebook = new DestumSliderFacebook();
						$return = $facebook->get_photo_set_photos_options($data['url'],$data['album'],$data['app_id'],$data['app_secret']);
						if(!empty($return)){
							self::ajaxResponseSuccess(__('Successfully fetched Facebook albums', 'DestumSlider'), array('html'=>implode(' ', $return)));
						}
						else{
							$error = __('Could not fetch Facebook albums', 'DestumSlider');
							self::ajaxResponseError($error);	
						}
					}
					else {
						self::ajaxResponseSuccess(__('Cleared Albums', 'DestumSlider'), array('html'=>implode(' ', $return)));
					}
				break;
				case "get_flickr_photosets":
					if(!empty($data['url']) && !empty($data['key'])){
						$flickr = new DestumSliderFlickr($data['key']);
						$user_id = $flickr->get_user_from_url($data['url']);
						$return = $flickr->get_photo_sets($user_id,$data['count'],$data['set']);
						if(!empty($return)){
							self::ajaxResponseSuccess(__('Successfully fetched flickr photosets', 'DestumSlider'), array("data"=>array('html'=>implode(' ', $return))));
						}
						else{
							$error = __('Could not fetch flickr photosets', 'DestumSlider');
							self::ajaxResponseError($error);
						}
					}
					else {
						if(empty($data['url']) && empty($data['key'])){
							self::ajaxResponseSuccess(__('Cleared Photosets', 'DestumSlider'), array('html'=>implode(' ', $return)));
						}
						elseif(empty($data['url'])){
							$error = __('No User URL - Could not fetch flickr photosets', 'DestumSlider');
							self::ajaxResponseError($error);
						}
						else{
							$error = __('No API KEY - Could not fetch flickr photosets', 'DestumSlider');
							self::ajaxResponseError($error);
						}
					}
				break;
				case "get_youtube_playlists":
					if(!empty($data['id'])){
						$youtube = new DestumSliderYoutube(trim($data['api']),trim($data['id']));
						$return = $youtube->get_playlist_options($data['playlist']);
						self::ajaxResponseSuccess(__('Successfully fetched YouTube playlists', 'DestumSlider'), array("data"=>array('html'=>implode(' ', $return))));
					}
					else {
						$error = __('Could not fetch YouTube playlists', 'DestumSlider');
						self::ajaxResponseError($error);
					}
				break;
				case 'rs_get_store_information': 
					global $wp_version, $rslb;
					
					$code = get_option('DestumSlider-code', '');
					$shop_version = DestumSliderTemplate::SHOP_VERSION;
					
					$validated = get_option('DestumSlider-valid', 'false');
					if($validated == 'false'){
						$api_key = '';
						$username = '';
						$code = '';
					}
					
					$rattr = array(
						'code' => urlencode($code),
						'product' => urlencode('DestumSlider'),
						'shop_version' => urlencode($shop_version),
						'version' => urlencode(DestumSliderGlobals::SLIDER_REVISION)
					);
					
					$done	= false;
					$count	= 0;
					do {
						$url		= $rslb->get_url('templates');
						$request	= wp_remote_post($url.'/DestumSlider/store.php', array(
							'user-agent' => 'WordPress/'.$wp_version.'; '.get_bloginfo('url'),
							'body' => $rattr
						));
						
						$response = '';
						
						if(!is_wp_error($request)) {
							$response	= json_decode(@$request['body'], true);
							$done		= true;
						}else{
							$rslb->move_server_list();
						}
						
						$count++;
					}while($done == false && $count < 5);
					
					self::ajaxResponseData(array("data"=>$response));
				break;
				case 'load_library_object': 
					$obj_library = new DestumSliderObjectLibrary();
					
					$thumbhandle = $data['handle'];
					$type = $data['type'];
					if($type == 'thumb'){
						$thumb = $obj_library->_get_object_thumb($thumbhandle, 'thumb');
					}elseif($type == 'orig'){
						$thumb = $obj_library->_get_object_thumb($thumbhandle, 'original');
					}
					if($thumb['error']){
						self::ajaxResponseError(__('Object could not be loaded', 'DestumSlider'));
					}else{
						self::ajaxResponseData(array('url'=> $thumb['url'], 'width' => $thumb['width'], 'height' => $thumb['height']));
					}
				break;
				case 'load_template_store_sliders': 
					$tmpl = new DestumSliderTemplate();

					$tp_template_slider = $tmpl->getThemePunchTemplateSliders();
					
					ob_start();
					$tmpl->create_html_sliders($tp_template_slider);
					$html = ob_get_contents();
					ob_clean();
					ob_end_clean();
					
					self::ajaxResponseData(array('html'=> $html));
					
				break;
				case 'load_template_store_slides': 
					$tmpl = new DestumSliderTemplate();

					$templates = $tmpl->getTemplateSlides();
					$tp_template_slider = $tmpl->getThemePunchTemplateSliders();

					$tmp_slider = new DestumSlider();
					$all_slider = apply_filters('DestumSlider_slide_templates', $tmp_slider->getArrSliders());
					
					ob_start();
					$tmpl->create_html_slides($tp_template_slider, $all_slider, $templates);
					$html = ob_get_contents();
					ob_clean();
					ob_end_clean();
					
					self::ajaxResponseData(array('html'=> $html));
					
				break;
				case 'load_object_library': 
					$html = '';
					$obj = new DestumSliderObjectLibrary();
					$mdata = $obj->retrieve_all_object_data();
					
					self::ajaxResponseData(array('data'=> $mdata));
				break;
				case 'slide_editor_sticky_menu':
					if(isset($data['set_sticky']) && $data['set_sticky'] == 'true'){
						update_option('DestumSlider_slide_editor_sticky', 'true');
					}else{
						update_option('DestumSlider_slide_editor_sticky', 'false');
					}
					self::ajaxResponseData(array());
				break;
				case 'save_color_preset':
				
					$presets = TPColorpicker::save_color_presets($data['presets']);
					self::ajaxResponseData(array('presets' => $presets));
					
				break;
				default:
					$return = apply_filters('DestumSlider_admin_onAjaxAction_switch', false, $action, $data, $slider, $slide, $operations);
					if($return === false)
						self::ajaxResponseError("wrong ajax action: ".esc_attr($action));
					
					exit;
				break;
			}
			
			
			$role = self::getMenuRole(); //add additional security check and allow for example import only for admin
		}
		catch(Exception $e){

			$message = $e->getMessage();
			if($action == "preview_slide" || $action == "preview_slider"){
				echo $message;
				exit();
			}

			self::ajaxResponseError($message);
		}

		//it's an ajax action, so exit
		self::ajaxResponseError("No response output on $action action. please check with the developer.");
		exit();
	}
	
	
	/**
	 * onAjax action handler
	 */
	public static function onFrontAjaxAction(){
		$db = new DestumSliderDB();
		$slider = new DestumSlider();
		$slide = new RevSlide();
		$operations = new DestumSliderOperations();
		
		$token = self::getPostVar("token", false);
		
		//verify the token
		$isVerified = wp_verify_nonce($token, 'DestumSlider_Front');
		
		$error = false;
		if($isVerified){
			$data = self::getPostVar('data', false);
			switch(self::getPostVar('client_action', false)){
				case 'get_slider_html':
					$id = intval(self::getPostVar('id', 0));
					if($id > 0){
						$html = '';
						ob_start();
						$slider_class = DestumSliderOutput::putSlider($id);
						$html = ob_get_contents();
						
						//add styling
						$custom_css = DestumSliderOperations::getStaticCss();
						$custom_css = DestumSliderCssParser::compress_css($custom_css);
						$styles = $db->fetch(DestumSliderGlobals::$table_css);
						$styles = DestumSliderCssParser::parseDbArrayToCss($styles, "\n");
						$styles = DestumSliderCssParser::compress_css($styles);
						
						$html .= '<style type="text/css">'.$custom_css.'</style>';
						$html .= '<style type="text/css">'.$styles.'</style>';
						
						ob_clean();
						ob_end_clean();
						
						$result = (!empty($slider_class) && $html !== '') ? true : false;
						
						if(!$result){
							$error = __('Slider not found', 'DestumSlider');
						}else{
							
							if($html !== false){
								self::ajaxResponseData($html);
							}else{
								$error = __('Slider not found', 'DestumSlider');
							}
						}
					}else{
						$error = __('No Data Received', 'DestumSlider');
					}
				break;
			}
			
		}else{
			$error = true;
		}
		
		if($error !== false){
			$showError = __('Loading Error', 'DestumSlider');
			if($error !== true)
				$showError = __('Loading Error: ', 'DestumSlider').$error;
			
			self::ajaxResponseError($showError, false);
		}
		exit();
	}
	
}
?>