<?php
/**
 * The header for our theme
 * This is the template that displays all of the <head> section and everything up.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 * @since Business Consultr 1.0.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>

</head>

<body <?php body_class(); ?> >
<?php do_action( 'wp_body_open' ); ?>

	<div id="site-loader">
		<div class="site-loader-inner">
			<?php
				$src = get_theme_file_uri( '' );
				
				echo apply_filters( 'destum_preloader',
				sprintf( '<img src="%s" alt="%s">',
					esc_url( $src ), 
					esc_html__( 'Site Loader','destum-temp' )
				)); 
			?>
		</div>
	</div>

<div id="mySidenav" class="sidenav">
  <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
  <div class="offcanvas-navigation">
  <?php destum_get_menu( 'primary' ); ?>
</div>
</div>

	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#content">
			<?php echo esc_html__( 'Skip to content', 'destum-temp' ); ?>
		</a>
		<?php get_template_part( 'template-parts/header/offcanvas', 'menu' ); ?>
		<?php
			if( !destum_get_option( 'disable_top_header' ) ):
		?>
		<header class="wrapper top-header">
		
			<div class="container">
				<div class="row">
					<div class="col-xs-12 col-sm-10 col-md-10">
						<div class="top-header-left">
							<?php if ( destum_get_option( 'top_header_address') ): ?>
								<div class="list">
									<span class="kfi kfi-pin-alt"></span>
									<?php echo wp_kses_post(  destum_get_option( 'top_header_address' ) ); ?>
								</div>
							<?php endif; ?>
							<?php if ( destum_get_option( 'top_header_email') ): ?>
								<div class="list">
									<span class="kfi kfi-mail-alt"></span>
									<a href="mailto:<?php echo wp_kses_post(  destum_get_option( 'top_header_email' ) ); ?>">
										<?php echo wp_kses_post(  destum_get_option( 'top_header_email' ) ); ?>
									</a>
								</div>
							<?php endif; ?>
							<?php if ( destum_get_option( 'top_header_phone') ): ?>
								<div class="list">
									<span class="kfi kfi-phone"></span>
									<a href="tel:<?php echo wp_kses_post(  destum_get_option( 'top_header_phone' ) ); ?>">
										<?php echo wp_kses_post(  destum_get_option( 'top_header_phone' ) ); ?>
									</a>
								</div>
							<?php endif; ?>
						</div>
					</div>
					<div class="col-xs-12 col-sm-2 col-md-2">
						<div class="top-header-right">
						<div class="socialgroup">
							<?php destum_get_menu( 'social' ); ?>
						</div>
						<?php if( !destum_get_option( 'disable_search_icon' ) ):?>
								<span class="search-icon">
									<a href="#">
										<span class="kfi kfi-search" aria-hidden="true"></span>
									</a>
									<div id="search-form">
										<?php get_search_form(); ?>
									</div><!-- /#search-form -->
								</span>
						<?php endif; ?>
						<?php if( class_exists( 'WooCommerce' ) ): ?>
							<span class="cart-icon">
								<a href="<?php echo esc_url( wc_get_cart_url() ); ?>">
									<span class="kfi kfi-cart-alt"></span>
									<span class="count">
										<?php echo absint( WC()->cart->get_cart_contents_count() ); ?>
									</span>
								</a>
							</span>
						<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</header>
		<?php

		endif;
		?>
		
		
		

		<header id="masthead" class="wrapper site-header" role="banner">
			<div class="containerm col-md-11 middle">
				<div class="row">
					<div class="col-xs-5 col-sm-7 col-md-4">
						<?php get_template_part( 'template-parts/header/site', 'branding' ); ?>
					</div>
					<?php $class = ''; ?>
					<?php !destum_get_option( 'disable_header_button' ) ? $class = 'col-md-9' : $class = 'col-md-10'; ?>
					<div class="visible-md visible-lg <?php echo $class; ?>" id="primary-nav-container">
						<div id="navigation" class="hidden-xs hidden-sm">
						    <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Primary Menu', 'destum-temp' ); ?>">
						    	<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Primary Menu', 'destum-temp' ); ?></button>
								<?php echo destum_get_menu( 'primary' ); ?>
						    </nav>
						</div>
					</div>
					<div class="col-xs-7 col-sm-5 col-md-3" id="header-bottom-right-outer">
						<div class="header-bottom-right">
							<span class="alt-menu-icon visible-sm">
								<a class="offcanvas-menu-toggler"  onclick="openNav()">
									<span class="kfi kfi-menu"></span>
								</a>

							<script>
function openNav() {
  document.getElementById("mySidenav").style.width = "40%";
}

function closeNav() {
  document.getElementById("mySidenav").style.width = "0";
}

</script>
								
							</span>
							<?php if( !destum_get_option( 'disable_header_button' ) ): ?>
								<span class="callback-button">
									<a href="<?php echo wp_kses_post(  destum_get_option( 'header_button_link' ) ); ?>" class="button-primary">
										<?php echo wp_kses_post(  destum_get_option( 'header_button' ) ); ?>
									</a>
								</span>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
			
			

		</header><!-- #masthead -->
		
	<script>
window.onscroll = function() {myFunction()};

var header = document.getElementById("masthead");
var sticky = header.offsetTop;

function myFunction() {
  if (window.pageYOffset > sticky) {
    header.classList.add("sticky");
  } else {
    header.classList.remove("sticky");
  }
}

</script>
		<div id="content" class="wrapper site-main">

<div class="col-md-6">
<div class="popp">
<div id="raq" class="overlay1">
	<div class="popup">
		<h2>Position Applying For</h2>
		<a class="close" href="#_">×</a>
		<div class="content">
		<?php echo do_shortcode('[contact-form-7 id="509" title="job"]'); ?>
					
		</div>
	</div>
</div>
</div>
</div>