<?php
/**
* Destum breadcrumb.
*
* @since Destum 1.0.0
* @uses breadcrumb_trail()
*/
require get_parent_theme_file_path( '/modules/breadcrumbs/breadcrumbs.php' );
if ( ! function_exists( 'destum_breadcrumb' ) ) :

	function destum_breadcrumb() {

		$breadcrumb_args = apply_filters( 'destum_breadcrumb_args', array(
			'show_browse' => false,
		) );

		breadcrumb_trail( $breadcrumb_args );
	}

endif;

function destum_modify_breadcrumb( $crumb ){

	$i = count( $crumb ) - 1;
	$title = destum_remove_pipe( $crumb[ $i ] );

	$crumb[ $i ] = $title;

	return $crumb;
}
add_filter( 'breadcrumb_trail_items', 'destum_modify_breadcrumb' );