<?php
/**
* Sets sections for destum_Customizer
*
* @since  Destum 1.0.0
* @param  array $sections
* @return array Merged array
*/
function destum_Customizer_sections( $sections ){

	$destum_sections = array(
		
		# Section for Fronpage panel
		'slider' => array(
			'title' => esc_html__( 'Slider', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),
		'home_service' => array(
			'title' => esc_html__( 'Service', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),
		'home_about' => array(
			'title' => esc_html__( 'About', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),
		'home_portfolio' => array(
			'title' => esc_html__( 'Portfolio', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),
		'home_callback' => array(
			'title' => esc_html__( 'Callback', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),
		'home_testimonial' => array(
			'title' => esc_html__( 'Testimonial', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),
		'home_blog' => array(
			'title' => esc_html__( 'Blog', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),
		'home_contact' => array(
			'title' => esc_html__( 'Contact', 'destum-temp' ),
			'panel' => 'frontpage_options'
		),

		# Section for Theme Options panel
		'header_options' => array(
			'title' => esc_html__( 'Header Options', 'destum-temp' ),
			'panel' => 'theme_options'
		),
		'layout_options' => array(
			'title' => esc_html__( 'Layout Options', 'destum-temp' ),
			'panel' => 'theme_options'
		),
		'blog_options' => array(
			'title' => esc_html__( 'Blog Options', 'destum-temp' ),
			'panel' => 'theme_options'
		),
		'footer_options' => array(
			'title' => esc_html__( 'Footer Options', 'destum-temp' ),
			'panel' => 'theme_options'
		)
	);

	return array_merge( $destum_sections, $sections );
}
add_filter( 'destum_Customizer_sections', 'destum_Customizer_sections' );