<?php
/**
* Sets settings for general fields
*
* @since  Destum 1.0.0
* @param  array $settings
* @return array Merged array
*/

function destum_Customizer_general_settings( $settings ){

	$general = array(
		'site_title_color' => array(
			'label'     => esc_html__( 'Site Title', 'destum-temp' ),
			'transport' => 'postMessage',
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_tagline_color' => array(
			'label'     => esc_html__( 'Site Tagline', 'destum-temp' ),
			'transport' => 'postMessage',
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_primary_color' => array(
			'label'     => esc_html__( 'Primary', 'destum-temp' ),
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_secondary_color' => array(
			'label'     => esc_html__( 'Secondary', 'destum-temp' ),
			'section'   => 'colors',
			'type'      => 'colors',
		),
		'site_alternate_color' => array(
			'label'     => esc_html__( 'Alternate', 'destum-temp' ),
			'section'   => 'colors',
			'type'      => 'colors',
		),

		# Theme Options Section
		# Header
		'top_header_address' => array(
			'label'   => esc_html__( 'Address', 'destum-temp' ),
			'section' => 'header_options',
			'type'    => 'text',
		),
		'top_header_email' => array(
			'label'   => esc_html__( 'Email', 'destum-temp' ),
			'section' => 'header_options',
			'type'    => 'text',
		),
		'top_header_phone' => array(
			'label'   => esc_html__( 'Phone', 'destum-temp' ),
			'section' => 'header_options',
			'type'    => 'text',
		),
		'disable_top_header' => array(
			'label'     => esc_html__( 'Disable Top Header', 'destum-temp' ),
			'section'   => 'header_options',
			'transport' => 'postMessage',
			'type'      => 'checkbox',
		),
		'disable_search_icon' => array(
			'label'     => esc_html__( 'Disable Header Search Icon', 'destum-temp' ),
			'section'   => 'header_options',
			'type'      => 'checkbox',
		),
		'header_button' => array(
			'label'     => esc_html__( 'Header Button Text', 'destum-temp' ),
			'section'   => 'header_options',
			'transport' => 'postMessage',
			'type'      => 'text',
		),
		'header_button_link' => array(
			'label'     => esc_html__( 'Header Button Link', 'destum-temp' ),
			'section'   => 'header_options',
			'transport' => 'postMessage',
			'type'      => 'text',
		),
		'disable_header_button' => array(
			'label'   => esc_html__( 'Disable Header Button', 'destum-temp' ),
			'type'    => 'checkbox',
			'section' => 'header_options',
		),
		'disable_fixed_header' => array(
			'label'   => esc_html__( 'Disable Fixed Header', 'destum-temp' ),
			'type'    => 'checkbox',
			'section' => 'header_options',
		),
		# Layout
		'archive_layout' => array(
			'label'     => esc_html__( 'Archive Layout', 'destum-temp' ),
			'section'   => 'layout_options',
			'type'      => 'select',
			'choices'   => array(
				'left' => esc_html__( 'Left Sidebar', 'destum-temp' ),
				'right' => esc_html__( 'Right Sidebar', 'destum-temp' ),
				'none' => esc_html__( 'No Sidebar', 'destum-temp' ),
			),
		),
		'archive_post_layout' => array(
			'label'     => esc_html__( 'Archive Post Layout', 'destum-temp' ),
			'section'   => 'layout_options',
			'type'      => 'select',
			'choices'   => array(
				'grid' => esc_html__( 'Grid', 'destum-temp' ),
				'simple' => esc_html__( 'Simple', 'destum-temp' ),
			),
		),
		'archive_post_image' => array(
			'label'     => esc_html__( 'Archive Post Image', 'destum-temp' ),
			'section'   => 'layout_options',
			'type'      => 'select',
			'choices'   => array(
				'thumbnail' => esc_html__( 'Thumbnail (150x150)', 'destum-temp' ),
				'medium' => esc_html__( 'Medium (300x300)', 'destum-temp' ),
				'large' => esc_html__( 'Large (1024x1024)', 'destum-temp' ),
				'full' => esc_html__( 'Full (original)', 'destum-temp' ),
				'default' => esc_html__( 'Default (390x320)', 'destum-temp' ),
			),
		),
		'archive_post_image_alignment' => array(
			'label'     => esc_html__( 'Archive Post Image Alignment', 'destum-temp' ),
			'section'   => 'layout_options',
			'type'      => 'select',
			'choices'   => array(
				'left' => esc_html__( 'Left', 'destum-temp' ),
				'right' => esc_html__( 'Right', 'destum-temp' ),
				'center' => esc_html__( 'Center', 'destum-temp' ),
			),
		),
		# Blog
		'archive_page_title' => array(
			'label'   => esc_html__( 'Blog Page Title', 'destum-temp' ),
			'section' => 'blog_options',
			'type'    => 'text',
		),
		# Footer
		'enable_scroll_top_in_mobile' => array(
			'label'     => esc_html__( 'Enable Scroll top in mobile', 'destum-temp' ),
			'section'   => 'footer_options',
			'transport' => 'postMessage',
			'type'      => 'checkbox',
		),
		'disable_footer_widget' => array(
			'label'   => esc_html__( 'Disable Footer Widget', 'destum-temp' ),
			'section' => 'footer_options',
			'type'    => 'checkbox',
		),
		'footer_text' =>  array(
			'label'     => esc_html__( 'Footer Text', 'destum-temp' ),
			'section'   => 'footer_options',
			'type'      => 'textarea',
		)
	);

	return array_merge( $settings, $general );
}
add_filter( 'destum_Customizer_fields', 'destum_Customizer_general_settings' );